/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Converter;

@Converter(generateBulkLoader=true)
public final class DateTimeConverter {
    private DateTimeConverter() {
    }

    @Converter(order=1)
    public static TimeZone toTimeZone(String s2) {
        return TimeZone.getTimeZone(s2);
    }

    @Converter(order=2)
    public static Date toDate(Long l) {
        return new Date(l);
    }

    @Converter(order=3)
    public static Long toLong(Date date) {
        return date.getTime();
    }

    @Converter(order=4)
    public static TimeUnit toTimeUnit(String unit) {
        String match;
        return switch (match = unit.toUpperCase(Locale.ROOT).trim()) {
            case "DAYS" -> TimeUnit.DAYS;
            case "HOURS" -> TimeUnit.HOURS;
            case "MINUTES" -> TimeUnit.MINUTES;
            case "SECONDS" -> TimeUnit.SECONDS;
            case "MILLISECONDS" -> TimeUnit.MILLISECONDS;
            case "NANOSECONDS" -> TimeUnit.NANOSECONDS;
            default -> throw new IllegalStateException("Unexpected value: " + unit);
        };
    }
}

