/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.errorhandler;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.spi.ErrorHandler;
import org.apache.camel.support.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorHelper;
import org.apache.camel.support.service.ServiceHelper;

public class NoErrorHandler
extends ErrorHandlerSupport
implements AsyncProcessor,
ErrorHandler {
    private final AsyncProcessor output;

    public NoErrorHandler(Processor processor) {
        this.output = AsyncProcessorConverterHelper.convert(processor);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        return this.output.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                exchange.getExchangeExtension().setRedeliveryExhausted(false);
                callback.done(doneSync);
            }
        });
    }

    @Override
    public CompletableFuture<Exchange> processAsync(Exchange exchange) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> callback = new AsyncCallbackToCompletableFutureAdapter<Exchange>(exchange);
        this.process(exchange, callback);
        return callback.getFuture();
    }

    public String toString() {
        if (this.output == null) {
            return "";
        }
        return "NoErrorHandler[" + this.output + "]";
    }

    @Override
    public boolean supportTransacted() {
        return false;
    }

    @Override
    public Processor getOutput() {
        return this.output;
    }

    @Override
    public ErrorHandler clone(Processor output) {
        return new NoErrorHandler(output);
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.output);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.output);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.output);
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.output);
    }
}

