/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.IssueField;
import com.atlassian.jira.rest.client.internal.json.BasicUserJsonParser;
import com.atlassian.jira.rest.client.internal.json.JsonObjectParser;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IssueFieldJsonParser {
    private static final String VALUE_ATTRIBUTE = "value";
    private Map<String, JsonObjectParser> registeredValueParsers = new HashMap<String, JsonObjectParser>(){
        {
            this.put("com.atlassian.jira.plugin.system.customfieldtypes:float", new FloatingPointFieldValueParser());
            this.put("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", new FieldValueJsonParser<BasicUser>(new BasicUserJsonParser()));
            this.put("java.lang.String", new StringFieldValueParser());
        }
    };

    public IssueField parse(JSONObject jsonObject, String id) throws JSONException {
        JsonObjectParser valueParser;
        String type = jsonObject.getString("type");
        String name = jsonObject.getString("name");
        Object valueObject = jsonObject.opt(VALUE_ATTRIBUTE);
        if ("comment".equals(name)) {
            type = "com.atlassian.jira.Comment";
        }
        Object value = valueObject == null ? null : ((valueParser = this.registeredValueParsers.get(type)) != null ? valueParser.parse(jsonObject) : valueObject.toString());
        return new IssueField(id, name, type, value);
    }

    static class StringFieldValueParser
    implements JsonObjectParser<String> {
        StringFieldValueParser() {
        }

        @Override
        public String parse(JSONObject jsonObject) throws JSONException {
            return JsonParseUtil.getNullableString(jsonObject, IssueFieldJsonParser.VALUE_ATTRIBUTE);
        }
    }

    static class FloatingPointFieldValueParser
    implements JsonObjectParser<Double> {
        FloatingPointFieldValueParser() {
        }

        @Override
        public Double parse(JSONObject jsonObject) throws JSONException {
            String s2 = JsonParseUtil.getNullableString(jsonObject, IssueFieldJsonParser.VALUE_ATTRIBUTE);
            if (s2 == null) {
                return null;
            }
            try {
                return Double.parseDouble(s2);
            }
            catch (NumberFormatException e) {
                throw new JSONException("[" + s2 + "] is not a valid floating point number");
            }
        }
    }

    static class FieldValueJsonParser<T>
    implements JsonObjectParser<T> {
        private final JsonObjectParser<T> jsonParser;

        public FieldValueJsonParser(JsonObjectParser<T> jsonParser) {
            this.jsonParser = jsonParser;
        }

        @Override
        public T parse(JSONObject json) throws JSONException {
            JSONObject valueObject = json.optJSONObject(IssueFieldJsonParser.VALUE_ATTRIBUTE);
            if (valueObject == null) {
                throw new JSONException("Expected JSONObject with [value] attribute present.");
            }
            return this.jsonParser.parse(valueObject);
        }
    }
}

