/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api;

import com.atlassian.jira.rest.client.api.GetCreateIssueMetadataOptions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;

public class GetCreateIssueMetadataOptionsBuilder {
    private Iterable<String> expandos = Sets.newHashSet();
    private Iterable<String> issueTypeNames;
    private Iterable<Long> issueTypeIds;
    private Iterable<String> projectKeys;
    private Iterable<Long> projectIds;

    public GetCreateIssueMetadataOptionsBuilder withExpandos(Iterable<String> expandos) {
        this.expandos = expandos;
        return this;
    }

    public GetCreateIssueMetadataOptionsBuilder withExpandos(String ... expandos) {
        return this.withExpandos(ImmutableList.copyOf(expandos));
    }

    public GetCreateIssueMetadataOptionsBuilder withExpandedIssueTypesFields() {
        return this.withExpandos(ImmutableList.of("projects.issuetypes.fields"));
    }

    public GetCreateIssueMetadataOptionsBuilder withIssueTypeNames(Iterable<String> issueTypeNames) {
        this.issueTypeNames = issueTypeNames;
        return this;
    }

    public GetCreateIssueMetadataOptionsBuilder withIssueTypeNames(String ... issueTypeNames) {
        return this.withIssueTypeNames(ImmutableList.copyOf(issueTypeNames));
    }

    public GetCreateIssueMetadataOptionsBuilder withIssueTypeIds(Iterable<Long> issueTypeIds) {
        this.issueTypeIds = issueTypeIds;
        return this;
    }

    public GetCreateIssueMetadataOptionsBuilder withIssueTypeIds(Long ... issueTypeIds) {
        return this.withIssueTypeIds(ImmutableList.copyOf(issueTypeIds));
    }

    public GetCreateIssueMetadataOptionsBuilder withProjectKeys(Iterable<String> projectKeys) {
        this.projectKeys = projectKeys;
        return this;
    }

    public GetCreateIssueMetadataOptionsBuilder withProjectKeys(String ... projectKeys) {
        return this.withProjectKeys(ImmutableList.copyOf(projectKeys));
    }

    public GetCreateIssueMetadataOptionsBuilder withProjectIds(Iterable<Long> projectIds) {
        this.projectIds = projectIds;
        return this;
    }

    public GetCreateIssueMetadataOptionsBuilder withProjectIds(Long ... projectIds) {
        return this.withProjectIds(ImmutableList.copyOf(projectIds));
    }

    public GetCreateIssueMetadataOptions build() {
        return new GetCreateIssueMetadataOptions(this.expandos, this.issueTypeNames, this.issueTypeIds, this.projectKeys, this.projectIds);
    }
}

