/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public class Visibility {
    private final Type type;
    private final String value;

    public Visibility(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public static Visibility role(String value) {
        return new Visibility(Type.ROLE, value);
    }

    public static Visibility group(String group) {
        return new Visibility(Type.GROUP, group);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("value", this.value).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Visibility) {
            Visibility that = (Visibility)obj;
            return Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.value, that.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.type, this.value});
    }

    public static enum Type {
        ROLE,
        GROUP;

    }
}

