/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json.gen;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.AssigneeType;
import com.atlassian.jira.rest.client.internal.domain.input.ComponentInputWithProjectKey;
import com.atlassian.jira.rest.client.internal.json.gen.JsonGenerator;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ComponentInputWithProjectKeyJsonGenerator
implements JsonGenerator<ComponentInputWithProjectKey> {
    @Override
    public JSONObject generate(ComponentInputWithProjectKey componentInput) throws JSONException {
        AssigneeType assigneeType;
        JSONObject res = new JSONObject();
        if (componentInput.getProjectKey() != null) {
            res.put("project", componentInput.getProjectKey());
        }
        if (componentInput.getName() != null) {
            res.put("name", componentInput.getName());
        }
        if (componentInput.getDescription() != null) {
            res.put("description", componentInput.getDescription());
        }
        if (componentInput.getLeadUsername() != null) {
            res.put("leadUserName", componentInput.getLeadUsername());
        }
        if ((assigneeType = componentInput.getAssigneeType()) != null) {
            res.put("assigneeType", switch (assigneeType) {
                case AssigneeType.PROJECT_DEFAULT -> "PROJECT_DEFAULT";
                case AssigneeType.COMPONENT_LEAD -> "COMPONENT_LEAD";
                case AssigneeType.PROJECT_LEAD -> "PROJECT_LEAD";
                case AssigneeType.UNASSIGNED -> "UNASSIGNED";
                default -> throw new RestClientException("Unexpected assignee type [" + assigneeType + "]", null);
            });
        }
        return res;
    }
}

