/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.transformer.CustomTransformerDefinition;
import org.apache.camel.model.transformer.DataFormatTransformerDefinition;
import org.apache.camel.model.transformer.EndpointTransformerDefinition;
import org.apache.camel.model.transformer.LoadTransformerDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Transformer;
import org.apache.camel.util.ObjectHelper;

public class TransformerBuilder {
    private String scheme;
    private String name;
    private String from;
    private String to;
    private String uri;
    private DataFormatDefinition dataFormat;
    private Class<? extends Transformer> clazz;
    private String beanRef;
    private boolean defaults;
    private String packageScan;

    public TransformerBuilder name(String name) {
        this.name = name;
        return this;
    }

    public TransformerBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public TransformerBuilder fromType(String from) {
        this.from = from;
        return this;
    }

    public TransformerBuilder fromType(Class<?> from) {
        this.from = new DataType(from).toString();
        return this;
    }

    public TransformerBuilder toType(String to) {
        this.to = to;
        return this;
    }

    public TransformerBuilder toType(Class<?> to) {
        this.to = new DataType(to).toString();
        return this;
    }

    public TransformerBuilder withUri(String uri) {
        this.resetType();
        this.uri = uri;
        return this;
    }

    public TransformerBuilder withDataFormat(DataFormatDefinition dataFormatDefinition) {
        this.resetType();
        this.dataFormat = dataFormatDefinition;
        return this;
    }

    public TransformerBuilder withJava(Class<? extends Transformer> clazz) {
        this.resetType();
        this.clazz = clazz;
        return this;
    }

    public TransformerBuilder withBean(String ref) {
        this.resetType();
        this.beanRef = ref;
        return this;
    }

    public TransformerBuilder withDefaults() {
        this.resetType();
        this.defaults = true;
        return this;
    }

    public TransformerBuilder scan(String location) {
        this.resetType();
        this.packageScan = location;
        return this;
    }

    private void resetType() {
        this.uri = null;
        this.dataFormat = null;
        this.clazz = null;
        this.beanRef = null;
        this.defaults = false;
        this.packageScan = null;
    }

    public void configure(CamelContext camelContext) {
        TransformerDefinition transformer;
        if (this.uri != null) {
            EndpointTransformerDefinition etd = new EndpointTransformerDefinition();
            etd.setUri(this.uri);
            transformer = etd;
        } else if (this.dataFormat != null) {
            DataFormatTransformerDefinition dtd = new DataFormatTransformerDefinition();
            dtd.setDataFormatType(this.dataFormat);
            transformer = dtd;
        } else if (this.clazz != null) {
            CustomTransformerDefinition ctd = new CustomTransformerDefinition();
            ctd.setClassName(this.clazz.getName());
            transformer = ctd;
        } else if (this.beanRef != null) {
            CustomTransformerDefinition ctd = new CustomTransformerDefinition();
            ctd.setRef(this.beanRef);
            transformer = ctd;
        } else if (this.defaults) {
            LoadTransformerDefinition ltd = new LoadTransformerDefinition();
            ltd.setDefaults("true");
            transformer = ltd;
        } else if (this.packageScan != null) {
            LoadTransformerDefinition ltd = new LoadTransformerDefinition();
            ltd.setPackageScan(this.packageScan);
            transformer = ltd;
        } else {
            throw new IllegalArgumentException("No Transformer type was specified");
        }
        if (ObjectHelper.isNotEmpty(this.scheme)) {
            transformer.setScheme(this.scheme);
            transformer.setName(this.name);
        } else if (ObjectHelper.isNotEmpty(this.name)) {
            transformer.setName(this.name);
        } else {
            transformer.setFromType(this.from);
            transformer.setToType(this.to);
        }
        camelContext.getTransformerRegistry();
        ((ModelCamelContext)camelContext).registerTransformer(transformer);
    }
}

