/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.URISupport;

public abstract class GenericFileSendDynamicAware
extends SendDynamicAwareSupport {
    public static final String PROP_FILE_NAME = "fileName";
    public static final String PROP_TEMP_FILE_NAME = "tempFileName";
    public static final String PROP_IDEMPOTENT_KEY = "idempotentKey";
    public static final String PROP_MOVE = "move";
    public static final String PROP_MOVE_FAILED = "moveFailed";
    public static final String PROP_PRE_MOVE = "preMove";
    public static final String PROP_MOVE_EXISTING = "moveExisting";

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    @Override
    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map<String, Object> properties = this.endpointProperties(exchange, uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, null);
    }

    @Override
    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String uri = entry.getUri();
        uri = uri.replace("\t", "\\\\t");
        boolean fileName = entry.getProperties().containsKey(PROP_FILE_NAME);
        boolean tempFileName = entry.getProperties().containsKey(PROP_TEMP_FILE_NAME);
        boolean idempotentKey = entry.getProperties().containsKey(PROP_IDEMPOTENT_KEY);
        boolean move = entry.getProperties().containsKey(PROP_MOVE);
        boolean moveFailed = entry.getProperties().containsKey(PROP_MOVE_FAILED);
        boolean preMove = entry.getProperties().containsKey(PROP_PRE_MOVE);
        boolean moveExisting = entry.getProperties().containsKey(PROP_MOVE_EXISTING);
        if (fileName || tempFileName || idempotentKey || move || moveFailed || preMove || moveExisting) {
            Map<String, Object> params = entry.getProperties();
            Map<String, Object> originalParams = URISupport.parseQuery(URISupport.extractQuery(entry.getOriginalUri()));
            if (fileName) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_FILE_NAME, params);
            }
            if (tempFileName) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_TEMP_FILE_NAME, params);
            }
            if (idempotentKey) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_IDEMPOTENT_KEY, params);
            }
            if (move) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_MOVE, params);
            }
            if (moveFailed) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_MOVE_FAILED, params);
            }
            if (preMove) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_PRE_MOVE, params);
            }
            if (moveExisting) {
                GenericFileSendDynamicAware.compute(originalParams, PROP_MOVE_EXISTING, params);
            }
            return this.asEndpointUri(exchange, uri, params);
        }
        return uri;
    }

    private static void compute(Map<String, Object> originalParams, String propFileName, Map<String, Object> params) {
        Object val = originalParams.get(propFileName);
        if (val != null) {
            params.put(propFileName, val.toString());
        }
    }

    @Override
    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    @Override
    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }
}

