/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jira.JiraConfiguration;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.JiraType;
import org.apache.camel.component.jira.JiraVerifierExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;

@Component(value="jira")
public class JiraComponent
extends HealthCheckComponent {
    @Metadata(label="advanced")
    private JiraConfiguration configuration = new JiraConfiguration();

    public JiraComponent() {
        this(null);
    }

    public JiraComponent(CamelContext context) {
        super(context);
        this.registerExtension(new JiraVerifierExtension());
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JiraConfiguration config = this.configuration != null ? this.configuration.copy() : new JiraConfiguration();
        JiraEndpoint endpoint = new JiraEndpoint(uri, this, config);
        endpoint.setType(this.getCamelContext().getTypeConverter().convertTo(JiraType.class, remaining));
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    public JiraConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JiraConfiguration configuration) {
        this.configuration = configuration;
    }
}

