/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.apache.camel.util.CastUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIssuesConsumer
extends AbstractJiraConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NewIssuesConsumer.class);
    private final String jql;
    private long latestIssueId = -1L;

    public NewIssuesConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.jql = endpoint.getJql() + " ORDER BY key desc";
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.latestIssueId = this.findLatestIssueId();
    }

    protected long findLatestIssueId() {
        try {
            Queue<Issue> issues = this.getIssues(this.jql, 1);
            if (!issues.isEmpty()) {
                return issues.peek().getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    protected int doPoll() throws Exception {
        Queue<Issue> newIssues = this.getNewIssues();
        this.processBatch(CastUtils.cast(newIssues));
        return newIssues.size();
    }

    private Queue<Issue> getNewIssues() {
        Queue<Issue> issues;
        Object jqlFilter = this.latestIssueId > -1L ? "id > " + this.latestIssueId + " AND " + this.jql : this.jql;
        try {
            issues = this.getIssues((String)jqlFilter);
        }
        catch (RestClientException e) {
            String msg;
            int code;
            if (e.getStatusCode().isPresent() && (code = e.getStatusCode().get().intValue()) == 400 && (msg = e.getMessage()) != null && msg.contains("does not exist for the field 'id'")) {
                LOG.warn("Last issue id: {} no longer exists (could have been deleted). Will recover by fetching last issue id from JIRA and try again on next poll", (Object)this.latestIssueId);
                this.latestIssueId = this.findLatestIssueId();
                return new LinkedList<Issue>();
            }
            throw e;
        }
        if (!issues.isEmpty()) {
            this.latestIssueId = issues.element().getId();
        }
        return issues;
    }
}

