/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.oauth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.apache.camel.component.jira.oauth.OAuthHttpClientDecorator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAsynchronousHttpClientFactory {
    private static final String JIRA_REST_CLIENT_VERSION = MavenUtils.getVersion("com.atlassian.jira", "jira-rest-java-client-api");

    public DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        HttpClientOptions options = new HttpClientOptions();
        final DefaultHttpClientFactory<Object> defaultHttpClientFactory = new DefaultHttpClientFactory<Object>(new NoOpEventPublisher(), new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager<Object>(){

            @Override
            public Object getThreadLocalContext() {
                return null;
            }

            @Override
            public void setThreadLocalContext(Object context) {
            }

            @Override
            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new OAuthHttpClientDecorator(httpClient, authenticationHandler){

            @Override
            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        @Override
        public void publish(Object o) {
        }

        @Override
        public void register(Object o) {
        }

        @Override
        public void unregister(Object o) {
        }

        @Override
        public void unregisterAll() {
        }
    }

    private static final class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        @Override
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        @Override
        public String getDisplayName() {
            return "Atlassian JIRA Rest Java Client";
        }

        @Override
        public String getPlatformId() {
            return "jira";
        }

        @Override
        public String getVersion() {
            return JIRA_REST_CLIENT_VERSION;
        }

        @Override
        public Date getBuildDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBuildNumber() {
            return String.valueOf(0);
        }

        @Override
        public File getHomeDirectory() {
            return new File(".");
        }

        @Override
        public Optional<Path> getLocalHomeDirectory() {
            return Optional.empty();
        }

        @Override
        public Optional<Path> getSharedHomeDirectory() {
            return Optional.empty();
        }

        @Override
        public String getPropertyValue(String s2) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public String getApplicationFileEncoding() {
            return "UTF-8";
        }
    }

    private static final class MavenUtils {
        private static final Logger LOG = LoggerFactory.getLogger(MavenUtils.class);
        private static final String UNKNOWN_VERSION = "unknown";

        private MavenUtils() {
        }

        static String getVersion(String groupId, String artifactId) {
            String string;
            block8: {
                Properties props = new Properties();
                String pomProps = String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
                InputStream resourceAsStream = ObjectHelper.loadResourceAsStream(pomProps, OAuthAsynchronousHttpClientFactory.class.getClassLoader());
                try {
                    props.load(resourceAsStream);
                    string = props.getProperty("version", UNKNOWN_VERSION);
                    if (resourceAsStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceAsStream != null) {
                            try {
                                resourceAsStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.debug("Could not find version for Jira Rest Java Client maven artifact {}:{}. Error: {}", new Object[]{groupId, artifactId, e.getMessage()});
                        return UNKNOWN_VERSION;
                    }
                }
                resourceAsStream.close();
            }
            return string;
        }
    }
}

