/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LimitedPollingConsumerPollStrategy
extends DefaultPollingConsumerPollStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(LimitedPollingConsumerPollStrategy.class);
    private final Map<Consumer, Integer> state = new HashMap<Consumer, Integer>();
    private int limit = 3;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
        this.state.remove(consumer);
    }

    @Override
    public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
        Integer times = this.state.get(consumer);
        times = times == null ? Integer.valueOf(1) : Integer.valueOf(times + 1);
        LOG.debug("Rollback occurred after {} times when consuming {}", (Object)times, (Object)endpoint);
        boolean retry = false;
        if (times >= this.limit) {
            this.state.remove(consumer);
            this.onSuspend(consumer, endpoint);
        } else {
            this.state.put(consumer, times);
            retry = this.onRollback(consumer, endpoint);
        }
        return retry;
    }

    protected void onSuspend(Consumer consumer, Endpoint endpoint) throws Exception {
        LOG.warn("Suspending consumer {} after {} attempts to consume from {}. You have to manually resume the consumer!", new Object[]{consumer, this.limit, endpoint});
        ServiceHelper.suspendService(consumer);
    }

    protected boolean onRollback(Consumer consumer, Endpoint endpoint) throws Exception {
        return false;
    }

    @Override
    protected void doStop() throws Exception {
        this.state.clear();
    }
}

