/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison;

import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.jettison.internal.entity.JettisonArrayProvider;
import org.glassfish.jersey.jettison.internal.entity.JettisonJaxbElementProvider;
import org.glassfish.jersey.jettison.internal.entity.JettisonListElementProvider;
import org.glassfish.jersey.jettison.internal.entity.JettisonObjectProvider;
import org.glassfish.jersey.jettison.internal.entity.JettisonRootElementProvider;

public class JettisonFeature
implements Feature {
    private static final String JSON_FEATURE = JettisonFeature.class.getSimpleName();
    private static Class[] PROVIDERS = new Class[]{JettisonArrayProvider.App.class, JettisonArrayProvider.General.class, JettisonObjectProvider.App.class, JettisonObjectProvider.General.class, JettisonRootElementProvider.App.class, JettisonRootElementProvider.General.class, JettisonJaxbElementProvider.App.class, JettisonJaxbElementProvider.General.class, JettisonListElementProvider.App.class, JettisonListElementProvider.General.class};

    @Override
    public boolean configure(FeatureContext context) {
        Configuration config = context.getConfiguration();
        String jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class);
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature)) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        for (Class provider : PROVIDERS) {
            context.register(provider, MessageBodyReader.class, MessageBodyWriter.class);
        }
        return true;
    }
}

