/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.NonManagedService;
import org.apache.camel.component.jms.ConsumerType;
import org.apache.camel.component.jms.DefaultJmsMessageListenerContainer;
import org.apache.camel.component.jms.DefaultSpringErrorHandler;
import org.apache.camel.component.jms.SimpleJmsMessageListenerContainer;
import org.apache.camel.component.jms.TemporaryQueueResolver;
import org.apache.camel.component.jms.reply.ReplyHandler;
import org.apache.camel.component.jms.reply.ReplyManager;
import org.apache.camel.component.jms.reply.ReplyManagerSupport;
import org.apache.camel.component.jms.reply.TemporaryQueueReplyHandler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.destination.DestinationResolver;

public class TemporaryQueueReplyManager
extends ReplyManagerSupport {
    final TemporaryReplyQueueDestinationResolver destinationResolver;

    public TemporaryQueueReplyManager(CamelContext camelContext, TemporaryQueueResolver resolver) {
        super(camelContext);
        this.destinationResolver = new TemporaryReplyQueueDestinationResolver(resolver);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.destinationResolver);
    }

    @Override
    protected ReplyHandler createReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String originalCorrelationId, String correlationId, long requestTimeout) {
        return new TemporaryQueueReplyHandler(this, exchange, callback, originalCorrelationId, correlationId, requestTimeout);
    }

    @Override
    public void updateCorrelationId(String correlationId, String newCorrelationId, long requestTimeout) {
        this.log.trace("Updated provisional correlationId [{}] to expected correlationId [{}]", (Object)correlationId, (Object)newCorrelationId);
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationId);
        if (handler != null) {
            this.correlation.put(newCorrelationId, handler, requestTimeout);
        }
    }

    @Override
    protected void handleReplyMessage(String correlationID, jakarta.jms.Message message, Session session) {
        ReplyHandler handler = (ReplyHandler)this.correlation.remove(correlationID);
        if (handler == null && this.endpoint.isUseMessageIDAsCorrelationID()) {
            handler = this.waitForProvisionCorrelationToBeUpdated(correlationID, message);
        }
        if (handler != null) {
            handler.onReply(correlationID, message, session);
        } else {
            this.log.warn("Reply received for unknown correlationID [{}]. The message will be ignored: {}", (Object)correlationID, (Object)message);
        }
    }

    @Override
    public void setReplyToSelectorHeader(Message camelMessage, jakarta.jms.Message jmsMessage) throws JMSException {
    }

    @Override
    protected AbstractMessageListenerContainer createListenerContainer() throws Exception {
        if (this.endpoint.getConfiguration().getReplyToConsumerType() == ConsumerType.Default) {
            return this.createDefaultListenerContainer();
        }
        if (this.endpoint.getConfiguration().getReplyToConsumerType() == ConsumerType.Simple) {
            return this.createSimpleListenerContainer();
        }
        return TemporaryQueueReplyManager.getAbstractMessageListenerContainer(this.endpoint);
    }

    protected AbstractMessageListenerContainer createDefaultListenerContainer() throws Exception {
        DefaultJmsMessageListenerContainer answer = new DefaultJmsMessageListenerContainer(this.endpoint, this.endpoint.isAllowReplyManagerQuickStop());
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(this.destinationResolver);
        answer.setAutoStartup(true);
        if (this.endpoint.getMaxMessagesPerTask() >= 0) {
            answer.setMaxMessagesPerTask(this.endpoint.getMaxMessagesPerTask());
        }
        answer.setIdleConsumerLimit(this.endpoint.getIdleConsumerLimit());
        answer.setIdleTaskExecutionLimit(this.endpoint.getIdleTaskExecutionLimit());
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        if (this.endpoint.getReplyToMaxConcurrentConsumers() > 0) {
            answer.setMaxConcurrentConsumers(this.endpoint.getReplyToMaxConcurrentConsumers());
        }
        answer.setConnectionFactory(this.endpoint.getConfiguration().getOrCreateConnectionFactory());
        if (this.endpoint.getReplyToCacheLevelName() != null) {
            if ("CACHE_NONE".equals(this.endpoint.getReplyToCacheLevelName())) {
                throw new IllegalArgumentException("ReplyToCacheLevelName cannot be CACHE_NONE when using temporary reply queues. The value must be either CACHE_CONSUMER, or CACHE_SESSION");
            }
            answer.setCacheLevelName(this.endpoint.getReplyToCacheLevelName());
        } else {
            answer.setCacheLevel(3);
        }
        TemporaryQueueReplyManager.setupClientId(this.endpoint, answer);
        answer.setSessionTransacted(false);
        answer.setExceptionListener(new TemporaryReplyQueueExceptionListener(this.destinationResolver, this.endpoint.getExceptionListener()));
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler(new DefaultSpringErrorHandler(this.endpoint.getCamelContext(), TemporaryQueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getReceiveTimeout() >= 0L) {
            answer.setReceiveTimeout(this.endpoint.getReceiveTimeout());
        }
        if (this.endpoint.getRecoveryInterval() >= 0L) {
            answer.setRecoveryInterval(this.endpoint.getRecoveryInterval());
        }
        if (this.endpoint.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            }
            answer.setTaskExecutor(this.endpoint.getTaskExecutor());
        }
        String name = "TemporaryQueueReplyManager[" + this.endpoint.getDestinationName() + "]";
        answer.setBeanName(name);
        if (answer.getConcurrentConsumers() > 1) {
            this.log.info("Using {}-{} concurrent consumers on {}", new Object[]{answer.getConcurrentConsumers(), answer.getMaxConcurrentConsumers(), name});
        }
        return answer;
    }

    private AbstractMessageListenerContainer createSimpleListenerContainer() {
        SimpleJmsMessageListenerContainer answer = new SimpleJmsMessageListenerContainer(this.endpoint);
        answer.setDestinationName("temporary");
        answer.setDestinationResolver(this.destinationResolver);
        answer.setAutoStartup(true);
        answer.setMessageListener(this);
        answer.setPubSubDomain(false);
        answer.setSubscriptionDurable(false);
        answer.setConcurrentConsumers(this.endpoint.getReplyToConcurrentConsumers());
        answer.setConnectionFactory(this.endpoint.getConfiguration().getOrCreateConnectionFactory());
        Object clientId = this.endpoint.getClientId();
        if (clientId != null) {
            clientId = (String)clientId + ".CamelReplyManager";
            answer.setClientId((String)clientId);
        }
        answer.setSessionTransacted(false);
        answer.setExceptionListener(new TemporaryReplyQueueExceptionListener(this.destinationResolver, this.endpoint.getExceptionListener()));
        if (this.endpoint.getErrorHandler() != null) {
            answer.setErrorHandler(this.endpoint.getErrorHandler());
        } else {
            answer.setErrorHandler(new DefaultSpringErrorHandler(this.endpoint.getCamelContext(), TemporaryQueueReplyManager.class, this.endpoint.getErrorHandlerLoggingLevel(), this.endpoint.isErrorHandlerLogStackTrace()));
        }
        if (this.endpoint.getTaskExecutor() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Using custom TaskExecutor: {} on listener container: {}", (Object)this.endpoint.getTaskExecutor(), (Object)answer);
            }
            answer.setTaskExecutor(this.endpoint.getTaskExecutor());
        }
        String name = "TemporaryQueueReplyManager[" + this.endpoint.getDestinationName() + "]";
        answer.setBeanName(name);
        if (this.endpoint.getReplyToConcurrentConsumers() > 1) {
            this.log.info("Using {} concurrent consumers on {}", (Object)this.endpoint.getReplyToConcurrentConsumers(), (Object)name);
        }
        return answer;
    }

    private final class TemporaryReplyQueueDestinationResolver
    extends ServiceSupport
    implements DestinationResolver,
    NonManagedService {
        private TemporaryQueue queue;
        private final AtomicBoolean refreshWanted = new AtomicBoolean();
        private final TemporaryQueueResolver custom;

        public TemporaryReplyQueueDestinationResolver(TemporaryQueueResolver custom) {
            this.custom = custom;
        }

        @Override
        public Destination resolveDestinationName(Session session, String destinationName, boolean pubSubDomain) throws JMSException {
            if (this.queue == null || this.refreshWanted.get()) {
                this.refreshWanted.set(false);
                if (this.custom != null) {
                    if (this.queue != null) {
                        try {
                            this.custom.delete(this.queue);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.queue = this.custom.createTemporaryQueue(session);
                } else {
                    this.queue = session.createTemporaryQueue();
                }
                TemporaryQueueReplyManager.this.setReplyTo(this.queue);
                if (TemporaryQueueReplyManager.this.log.isDebugEnabled()) {
                    TemporaryQueueReplyManager.this.log.debug("Refreshed Temporary ReplyTo Queue. New queue: {}", (Object)this.queue.getQueueName());
                }
            }
            return this.queue;
        }

        public void scheduleRefresh() {
            this.refreshWanted.set(true);
            TemporaryQueueReplyManager.this.replyTo = null;
        }

        @Override
        protected void doStop() throws Exception {
            if (this.queue != null) {
                try {
                    if (this.custom != null) {
                        this.custom.delete(this.queue);
                    } else {
                        this.queue.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.queue = null;
            }
        }
    }

    private final class TemporaryReplyQueueExceptionListener
    implements ExceptionListener {
        private final TemporaryReplyQueueDestinationResolver destResolver;
        private final ExceptionListener delegate;

        private TemporaryReplyQueueExceptionListener(TemporaryReplyQueueDestinationResolver destResolver, ExceptionListener delegate) {
            this.destResolver = destResolver;
            this.delegate = delegate;
        }

        @Override
        public void onException(JMSException exception) {
            String msg = "Exception inside the DMLC for Temporary ReplyTo Queue for destination " + TemporaryQueueReplyManager.this.endpoint.getDestinationName() + ", refreshing ReplyTo destination (stacktrace in DEBUG logging level).";
            boolean stopped = TemporaryQueueReplyManager.this.camelContext.isStopped();
            if (stopped) {
                TemporaryQueueReplyManager.this.log.debug(msg);
            } else {
                TemporaryQueueReplyManager.this.log.warn(msg);
            }
            if (TemporaryQueueReplyManager.this.log.isDebugEnabled()) {
                TemporaryQueueReplyManager.this.log.debug(msg, (Throwable)exception);
            }
            if (!stopped) {
                this.destResolver.scheduleRefresh();
                if (this.delegate != null) {
                    this.delegate.onException(exception);
                }
            }
        }
    }
}

