/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.messaginghub.pooled.jms.JmsPoolConnection;
import org.messaginghub.pooled.jms.JmsPoolJMSConsumer;
import org.messaginghub.pooled.jms.JmsPoolJMSProducer;
import org.messaginghub.pooled.jms.JmsPoolMessageConsumer;
import org.messaginghub.pooled.jms.JmsPoolMessageProducer;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.util.JMSExceptionSupport;

public class JmsPoolJMSContext
implements JMSContext,
AutoCloseable {
    protected final JmsPoolConnection connection;
    private final AtomicLong connectionRefCount;
    private final int sessionMode;
    private JmsPoolSession session;
    private JmsPoolMessageProducer sharedProducer;
    private boolean autoStart = true;

    public JmsPoolJMSContext(JmsPoolConnection connection, int sessionMode) {
        this(connection, sessionMode, new AtomicLong(1L));
    }

    private JmsPoolJMSContext(JmsPoolConnection connection, int sessionMode, AtomicLong connectionRefCount) {
        this.connection = connection;
        this.sessionMode = sessionMode;
        this.connectionRefCount = connectionRefCount;
    }

    @Override
    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public synchronized void close() {
        JMSRuntimeException failure;
        block7: {
            failure = null;
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException jmse) {
                failure = JMSExceptionSupport.createRuntimeException(jmse);
            }
            if (this.connectionRefCount.decrementAndGet() == 0L) {
                try {
                    this.connection.close();
                }
                catch (JMSException jmse) {
                    if (failure != null) break block7;
                    failure = JMSExceptionSupport.createRuntimeException(jmse);
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public void acknowledge() {
        if (this.getSessionMode() == 2) {
            throw new JMSRuntimeException("Pooled JMS Context does not support acknowledge() client must acknowledge messages");
        }
    }

    @Override
    public void commit() {
        try {
            this.getSession().commit();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void rollback() {
        try {
            this.getSession().rollback();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void recover() {
        try {
            this.getSession().recover();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void unsubscribe(String name) {
        try {
            this.getSession().unsubscribe(name);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public BytesMessage createBytesMessage() {
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public MapMessage createMapMessage() {
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public Message createMessage() {
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public ObjectMessage createObjectMessage() {
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public StreamMessage createStreamMessage() {
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public TextMessage createTextMessage() {
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public TextMessage createTextMessage(String text) {
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public Queue createQueue(String queueName) {
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public Topic createTopic(String topicName) {
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public TemporaryQueue createTemporaryQueue() {
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public synchronized JMSContext createContext(int sessionMode) {
        if (this.connectionRefCount.get() == 0L) {
            throw new IllegalStateRuntimeException("The Connection is closed");
        }
        this.validateSessionMode(sessionMode);
        this.connectionRefCount.incrementAndGet();
        return new JmsPoolJMSContext(this.connection, sessionMode, this.connectionRefCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSProducer createProducer() {
        if (this.connectionRefCount.get() == 0L) {
            throw new IllegalStateRuntimeException("The Connection is closed");
        }
        try {
            if (this.sharedProducer == null) {
                JmsPoolJMSContext jmsPoolJMSContext = this;
                synchronized (jmsPoolJMSContext) {
                    if (this.sharedProducer == null) {
                        this.sharedProducer = (JmsPoolMessageProducer)this.getSession().createProducer(null);
                    }
                }
            }
            return new JmsPoolJMSProducer(this.getSession(), this.sharedProducer);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createConsumer(destination)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String selector) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createConsumer(destination, selector)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createConsumer(Destination destination, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createConsumer(destination, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createDurableConsumer(topic, name, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createSharedConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createSharedConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createSharedConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createSharedDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JmsPoolJMSConsumer((JmsPoolMessageConsumer)this.getSession().createSharedDurableConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public QueueBrowser createBrowser(Queue queue, String selector) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue, selector));
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public boolean getAutoStart() {
        return this.autoStart;
    }

    @Override
    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException jmse) {
            throw JMSExceptionSupport.createRuntimeException(jmse);
        }
    }

    @Override
    public int getSessionMode() {
        return this.sessionMode;
    }

    @Override
    public boolean getTransacted() {
        return this.sessionMode == 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.connection + " }";
    }

    public Connection getConnection() {
        try {
            return this.connection.getConnection();
        }
        catch (JMSException jmsex) {
            throw JMSExceptionSupport.createRuntimeException(jmsex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JmsPoolSession getSession() {
        if (this.session == null) {
            JmsPoolJMSContext jmsPoolJMSContext = this;
            synchronized (jmsPoolJMSContext) {
                if (this.session == null) {
                    try {
                        this.session = (JmsPoolSession)this.connection.createSession(this.getSessionMode());
                    }
                    catch (JMSException jmse) {
                        throw JMSExceptionSupport.createRuntimeException(jmse);
                    }
                }
            }
        }
        return this.session;
    }

    private QueueBrowser startIfNeeded(QueueBrowser browser) throws JMSException {
        if (this.getAutoStart()) {
            this.connection.start();
        }
        return browser;
    }

    private JMSConsumer startIfNeeded(JMSConsumer consumer) throws JMSException {
        if (this.getAutoStart()) {
            this.connection.start();
        }
        return consumer;
    }

    private void validateSessionMode(int mode) {
        switch (mode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new JMSRuntimeException("Invalid Session Mode: " + mode);
    }
}

