/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.support.LoggingExceptionHandler;
import org.springframework.util.ErrorHandler;

public class DefaultSpringErrorHandler
implements ErrorHandler {
    private final LoggingExceptionHandler handler;
    private final boolean logStackTrace;

    public DefaultSpringErrorHandler(CamelContext camelContext, Class<?> owner, LoggingLevel level, boolean logStackTrace) {
        this.handler = new LoggingExceptionHandler(camelContext, owner, level);
        this.logStackTrace = logStackTrace;
    }

    @Override
    public void handleError(Throwable throwable) {
        if (this.logStackTrace) {
            this.handler.handleException("Execution of JMS message listener failed", throwable);
        } else {
            this.handler.handleException("Execution of JMS message listener failed. Caused by: [" + throwable.getMessage() + "]", null);
        }
    }
}

