/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import java.util.concurrent.atomic.AtomicBoolean;
import org.messaginghub.pooled.jms.JmsPoolSession;

public class JmsPoolMessageConsumer
implements MessageConsumer,
AutoCloseable {
    private final JmsPoolSession session;
    private final MessageConsumer messageConsumer;
    private final AtomicBoolean closed = new AtomicBoolean();

    JmsPoolMessageConsumer(JmsPoolSession session, MessageConsumer messageConsumer) {
        this.session = session;
        this.messageConsumer = messageConsumer;
    }

    @Override
    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.session.onConsumerClose(this);
            this.messageConsumer.close();
        }
    }

    @Override
    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageConsumer.getMessageListener();
    }

    @Override
    public String getMessageSelector() throws JMSException {
        this.checkClosed();
        return this.messageConsumer.getMessageSelector();
    }

    @Override
    public Message receive() throws JMSException {
        this.checkClosed();
        return this.messageConsumer.receive();
    }

    @Override
    public Message receive(long timeout) throws JMSException {
        this.checkClosed();
        return this.messageConsumer.receive(timeout);
    }

    @Override
    public Message receiveNoWait() throws JMSException {
        this.checkClosed();
        return this.messageConsumer.receiveNoWait();
    }

    @Override
    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageConsumer.setMessageListener(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.messageConsumer + " }";
    }

    public MessageConsumer getMessageConsumer() throws JMSException {
        this.checkClosed();
        return this.messageConsumer;
    }

    protected void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
    }

    protected MessageConsumer getDelegate() {
        return this.messageConsumer;
    }
}

