/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.event;

import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class GenericApplicationListenerAdapter
implements GenericApplicationListener {
    private static final Map<Class<?>, ResolvableType> eventTypeCache = new ConcurrentReferenceHashMap();
    private final ApplicationListener<ApplicationEvent> delegate;
    @Nullable
    private final ResolvableType declaredEventType;

    public GenericApplicationListenerAdapter(ApplicationListener<?> delegate) {
        Assert.notNull(delegate, "Delegate listener must not be null");
        this.delegate = delegate;
        this.declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(this.delegate);
    }

    @Override
    public void onApplicationEvent(ApplicationEvent event) {
        this.delegate.onApplicationEvent(event);
    }

    @Override
    public boolean supportsEventType(ResolvableType eventType) {
        ApplicationListener<ApplicationEvent> applicationListener = this.delegate;
        if (applicationListener instanceof GenericApplicationListener) {
            GenericApplicationListener gal = (GenericApplicationListener)applicationListener;
            return gal.supportsEventType(eventType);
        }
        applicationListener = this.delegate;
        if (applicationListener instanceof SmartApplicationListener) {
            SmartApplicationListener sal = (SmartApplicationListener)applicationListener;
            Class<?> eventClass = eventType.resolve();
            return eventClass != null && sal.supportsEventType(eventClass);
        }
        return this.declaredEventType == null || this.declaredEventType.isAssignableFrom(eventType);
    }

    @Override
    public boolean supportsSourceType(@Nullable Class<?> sourceType) {
        SmartApplicationListener sal;
        ApplicationListener<ApplicationEvent> applicationListener = this.delegate;
        return !(applicationListener instanceof SmartApplicationListener) || (sal = (SmartApplicationListener)applicationListener).supportsSourceType(sourceType);
    }

    @Override
    public int getOrder() {
        int n;
        ApplicationListener<ApplicationEvent> applicationListener = this.delegate;
        if (applicationListener instanceof Ordered) {
            Ordered ordered = (Ordered)((Object)applicationListener);
            n = ordered.getOrder();
        } else {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public String getListenerId() {
        String string;
        ApplicationListener<ApplicationEvent> applicationListener = this.delegate;
        if (applicationListener instanceof SmartApplicationListener) {
            SmartApplicationListener sal = (SmartApplicationListener)applicationListener;
            string = sal.getListenerId();
        } else {
            string = "";
        }
        return string;
    }

    @Nullable
    private static ResolvableType resolveDeclaredEventType(ApplicationListener<ApplicationEvent> listener) {
        Class<?> targetClass;
        ResolvableType declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(listener.getClass());
        if ((declaredEventType == null || declaredEventType.isAssignableFrom(ApplicationEvent.class)) && (targetClass = AopUtils.getTargetClass(listener)) != listener.getClass()) {
            declaredEventType = GenericApplicationListenerAdapter.resolveDeclaredEventType(targetClass);
        }
        return declaredEventType;
    }

    @Nullable
    static ResolvableType resolveDeclaredEventType(Class<?> listenerType) {
        ResolvableType eventType = eventTypeCache.get(listenerType);
        if (eventType == null) {
            eventType = ResolvableType.forClass(listenerType).as(ApplicationListener.class).getGeneric(new int[0]);
            eventTypeCache.put(listenerType, eventType);
        }
        return eventType != ResolvableType.NONE ? eventType : null;
    }
}

