/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Channel;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.TimerListener;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.management.CompositePerformanceCounter;
import org.apache.camel.management.DefaultInstrumentationProcessor;
import org.apache.camel.management.DelegatePerformanceCounter;
import org.apache.camel.management.InstrumentationInterceptStrategy;
import org.apache.camel.management.ManagedLoadTimer;
import org.apache.camel.management.PerformanceCounter;
import org.apache.camel.management.mbean.ManagedAsyncProcessorAwaitManager;
import org.apache.camel.management.mbean.ManagedBacklogDebugger;
import org.apache.camel.management.mbean.ManagedBacklogTracer;
import org.apache.camel.management.mbean.ManagedBeanIntrospection;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedConsumerCache;
import org.apache.camel.management.mbean.ManagedDumpRouteStrategy;
import org.apache.camel.management.mbean.ManagedEndpointRegistry;
import org.apache.camel.management.mbean.ManagedEndpointServiceRegistry;
import org.apache.camel.management.mbean.ManagedExchangeFactoryManager;
import org.apache.camel.management.mbean.ManagedInflightRepository;
import org.apache.camel.management.mbean.ManagedProducerCache;
import org.apache.camel.management.mbean.ManagedRestRegistry;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedRuntimeEndpointRegistry;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedShutdownStrategy;
import org.apache.camel.management.mbean.ManagedStreamCachingStrategy;
import org.apache.camel.management.mbean.ManagedThrottlingExceptionRoutePolicy;
import org.apache.camel.management.mbean.ManagedThrottlingInflightRoutePolicy;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.management.mbean.ManagedTransformerRegistry;
import org.apache.camel.management.mbean.ManagedTypeConverterRegistry;
import org.apache.camel.management.mbean.ManagedValidatorRegistry;
import org.apache.camel.management.mbean.ManagedVariableRepository;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BrowsableVariableRepository;
import org.apache.camel.spi.ConsumerCache;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementInterceptStrategy;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementObjectStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.support.TimerListenerManager;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.throttling.ThrottlingExceptionRoutePolicy;
import org.apache.camel.throttling.ThrottlingInflightRoutePolicy;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxManagementLifecycleStrategy
extends ServiceSupport
implements LifecycleStrategy,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JmxManagementLifecycleStrategy.class);
    private final Map<Processor, KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor<?>>> wrappedProcessors = new HashMap();
    private final List<java.util.function.Consumer<JmxManagementLifecycleStrategy>> preServices = new ArrayList<java.util.function.Consumer<JmxManagementLifecycleStrategy>>();
    private final TimerListenerManager loadTimer = new ManagedLoadTimer();
    private final TimerListenerManagerStartupListener loadTimerStartupListener = new TimerListenerManagerStartupListener();
    private volatile CamelContext camelContext;
    private volatile ManagedCamelContext camelContextMBean;
    private volatile boolean initialized;
    private final Set<String> knowRouteIds = new HashSet<String>();
    private final Map<BacklogTracer, ManagedBacklogTracer> managedBacklogTracers = new HashMap<BacklogTracer, ManagedBacklogTracer>();
    private final Map<DefaultBacklogDebugger, ManagedBacklogDebugger> managedBacklogDebuggers = new HashMap<DefaultBacklogDebugger, ManagedBacklogDebugger>();
    private final Map<ThreadPoolExecutor, Object> managedThreadPools = new HashMap<ThreadPoolExecutor, Object>();

    public JmxManagementLifecycleStrategy() {
    }

    public JmxManagementLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    List<java.util.function.Consumer<JmxManagementLifecycleStrategy>> getPreServices() {
        return this.preServices;
    }

    void addPreService(java.util.function.Consumer<JmxManagementLifecycleStrategy> preService) {
        this.preServices.add(preService);
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void onContextStarting(CamelContext context) throws VetoCamelContextStartException {
        Object me;
        Object mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
        String name = context.getName();
        String managementName = context.getManagementName();
        if (managementName == null) {
            managementName = context.getManagementNameStrategy().getName();
        }
        try {
            boolean done = false;
            while (!done) {
                ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForCamelContext(managementName, name);
                boolean exists = this.getManagementStrategy().isManagedName(on);
                if (!exists) {
                    done = true;
                    continue;
                }
                boolean fixed = false;
                String newName = this.findFreeName(context.getManagementNameStrategy(), name);
                if (newName != null) {
                    fixed = true;
                    done = true;
                    managementName = newName;
                }
                if (!fixed) {
                    throw new VetoCamelContextStartException("CamelContext (" + context.getName() + ") with ObjectName[" + String.valueOf(on) + "] is already registered. Make sure to use unique names on CamelContext when using multiple CamelContexts in the same MBeanServer.", context);
                }
                LOG.warn("This CamelContext({}) will be registered using the name: {} due to clash with an existing name already registered in MBeanServer.", (Object)context.getName(), (Object)managementName);
            }
        }
        catch (VetoCamelContextStartException e) {
            throw e;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        context.setManagementName(managementName);
        this.initialized = true;
        try {
            this.manageObject(mc);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        if (mc instanceof ManagedCamelContext) {
            ManagedCamelContext managedCamelContext;
            this.camelContextMBean = managedCamelContext = (ManagedCamelContext)mc;
        }
        this.enlistPreRegisteredServices();
        HealthCheckRegistry hcr = context.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (hcr != null) {
            try {
                me = this.getManagementObjectStrategy().getManagedObjectForCamelHealth(this.camelContext, hcr);
                if (me == null) {
                    return;
                }
                this.manageObject(me);
            }
            catch (Exception e) {
                LOG.warn("Could not register CamelHealth MBean. This exception will be ignored.", (Throwable)e);
            }
        }
        try {
            me = this.getManagementObjectStrategy().getManagedObjectForRouteController(this.camelContext, this.camelContext.getRouteController());
            if (me == null) {
                return;
            }
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register RouteController MBean. This exception will be ignored.", (Throwable)e);
        }
    }

    private String findFreeName(ManagementNameStrategy strategy, String name) throws MalformedObjectNameException {
        if (strategy.isFixedName()) {
            return null;
        }
        boolean done = false;
        String newName = null;
        while (!done) {
            newName = strategy.getNextName();
            ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForCamelContext(newName, name);
            boolean bl = done = !this.getManagementStrategy().isManagedName(on);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Using name: {} in ObjectName[{}] exists? {}", new Object[]{name, on, done});
        }
        return newName;
    }

    private void enlistPreRegisteredServices() {
        if (this.preServices.isEmpty()) {
            return;
        }
        LOG.debug("Registering {} pre registered services", (Object)this.preServices.size());
        for (java.util.function.Consumer<JmxManagementLifecycleStrategy> pre : this.preServices) {
            pre.accept(this);
        }
        this.preServices.clear();
    }

    @Override
    public void onContextStopped(CamelContext context) {
        Object mc;
        if (!this.initialized) {
            return;
        }
        try {
            mc = this.getManagementObjectStrategy().getManagedObjectForRouteController(context, context.getRouteController());
            if (this.getManagementStrategy().isManaged(mc)) {
                this.unmanageObject(mc);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unregister RouteController MBean", (Throwable)e);
        }
        try {
            mc = this.getManagementObjectStrategy().getManagedObjectForCamelContext(context);
            if (this.getManagementStrategy().isManaged(mc)) {
                this.unmanageObject(mc);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not unregister CamelContext MBean", (Throwable)e);
        }
        HealthCheckRegistry hcr = context.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (hcr != null) {
            try {
                Object mc2 = this.getManagementObjectStrategy().getManagedObjectForCamelHealth(context, hcr);
                if (this.getManagementStrategy().isManaged(mc2)) {
                    this.unmanageObject(mc2);
                }
            }
            catch (Exception e) {
                LOG.warn("Could not unregister CamelHealth MBean", (Throwable)e);
            }
        }
        this.camelContextMBean = null;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (!this.initialized) {
            this.preServices.add(lf -> lf.onComponentAdd(name, component));
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.manageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not register Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onComponentRemove(String name, Component component) {
        if (!this.initialized) {
            return;
        }
        try {
            Object mc = this.getManagementObjectStrategy().getManagedObjectForComponent(this.camelContext, component, name);
            this.unmanageObject(mc);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Component MBean", (Throwable)e);
        }
    }

    @Override
    public void onEndpointAdd(Endpoint endpoint) {
        if (!this.initialized) {
            this.preServices.add(lf -> lf.onEndpointAdd(endpoint));
            return;
        }
        if (!this.shouldRegister(endpoint, null)) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            if (me == null) {
                return;
            }
            this.manageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not register Endpoint MBean for endpoint: {}. This exception will be ignored.", (Object)endpoint, (Object)e);
        }
    }

    @Override
    public void onEndpointRemove(Endpoint endpoint) {
        if (!this.initialized) {
            return;
        }
        try {
            Object me = this.getManagementObjectStrategy().getManagedObjectForEndpoint(this.camelContext, endpoint);
            this.unmanageObject(me);
        }
        catch (Exception e) {
            LOG.warn("Could not unregister Endpoint MBean for endpoint: {}. This exception will be ignored.", (Object)endpoint, (Object)e);
        }
    }

    @Override
    public void onServiceAdd(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            this.preServices.add(lf -> lf.onServiceAdd(this.camelContext, service, route));
            return;
        }
        if (!this.shouldRegister(service, route)) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject == null) {
            return;
        }
        if (this.getManagementStrategy().isManaged(managedObject)) {
            LOG.trace("The service is already managed: {}", (Object)service);
            return;
        }
        try {
            this.manageObject(managedObject);
        }
        catch (Exception e) {
            LOG.warn("Could not register service: {} as Service MBean.", (Object)service, (Object)e);
        }
    }

    @Override
    public void onServiceRemove(CamelContext context, Service service, Route route) {
        if (!this.initialized) {
            return;
        }
        Object managedObject = this.getManagedObjectForService(context, service, route);
        if (managedObject != null) {
            try {
                this.unmanageObject(managedObject);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister service: {} as Service MBean.", (Object)service, (Object)e);
            }
        }
    }

    private Object getManagedObjectForService(CamelContext context, Service service, Route route) {
        if (service instanceof Channel || service instanceof UnitOfWork || service instanceof ManagementInterceptStrategy.InstrumentationProcessor) {
            return null;
        }
        if (service instanceof NonManagedService) {
            return null;
        }
        Object answer = null;
        if (service instanceof BacklogTracer) {
            BacklogTracer backlogTracer = (BacklogTracer)service;
            ManagedBacklogTracer mt = this.managedBacklogTracers.get(backlogTracer);
            if (mt == null) {
                mt = new ManagedBacklogTracer(context, backlogTracer);
                mt.init(this.getManagementStrategy());
                this.managedBacklogTracers.put(backlogTracer, mt);
            }
            return mt;
        }
        if (service instanceof DefaultBacklogDebugger) {
            DefaultBacklogDebugger backlogDebugger = (DefaultBacklogDebugger)service;
            ManagedBacklogDebugger md = this.managedBacklogDebuggers.get(backlogDebugger);
            if (md == null) {
                md = new ManagedBacklogDebugger(context, backlogDebugger);
                md.init(this.getManagementStrategy());
                this.managedBacklogDebuggers.put(backlogDebugger, md);
            }
            return md;
        }
        if (service instanceof Tracer) {
            Tracer tracer = (Tracer)service;
            ManagedTracer mt = new ManagedTracer(this.camelContext, tracer);
            mt.init(this.getManagementStrategy());
            answer = mt;
        } else if (service instanceof DumpRoutesStrategy) {
            DumpRoutesStrategy dumpRoutesStrategy = (DumpRoutesStrategy)service;
            ManagedDumpRouteStrategy mdrs = new ManagedDumpRouteStrategy(this.camelContext, dumpRoutesStrategy);
            mdrs.init(this.getManagementStrategy());
            answer = mdrs;
        } else if (service instanceof DataFormat) {
            DataFormat dataFormat = (DataFormat)service;
            answer = this.getManagementObjectStrategy().getManagedObjectForDataFormat(context, dataFormat);
        } else if (service instanceof Producer) {
            Producer producer = (Producer)service;
            answer = this.getManagementObjectStrategy().getManagedObjectForProducer(context, producer);
        } else if (service instanceof Consumer) {
            Consumer consumer = (Consumer)service;
            answer = this.getManagementObjectStrategy().getManagedObjectForConsumer(context, consumer);
        } else {
            if (service instanceof Processor) {
                Processor processor = (Processor)((Object)service);
                return this.getManagedObjectForProcessor(context, processor, route);
            }
            if (service instanceof ThrottlingInflightRoutePolicy) {
                ThrottlingInflightRoutePolicy throttlingInflightRoutePolicy = (ThrottlingInflightRoutePolicy)service;
                answer = new ManagedThrottlingInflightRoutePolicy(context, throttlingInflightRoutePolicy);
            } else if (service instanceof ThrottlingExceptionRoutePolicy) {
                ThrottlingExceptionRoutePolicy throttlingExceptionRoutePolicy = (ThrottlingExceptionRoutePolicy)service;
                answer = new ManagedThrottlingExceptionRoutePolicy(context, throttlingExceptionRoutePolicy);
            } else if (service instanceof ConsumerCache) {
                ConsumerCache consumerCache = (ConsumerCache)service;
                answer = new ManagedConsumerCache(context, consumerCache);
            } else if (service instanceof ProducerCache) {
                ProducerCache producerCache = (ProducerCache)service;
                answer = new ManagedProducerCache(context, producerCache);
            } else if (service instanceof ExchangeFactoryManager) {
                ExchangeFactoryManager exchangeFactoryManager = (ExchangeFactoryManager)service;
                answer = new ManagedExchangeFactoryManager(context, exchangeFactoryManager);
            } else if (service instanceof EndpointRegistry) {
                EndpointRegistry endpointRegistry = (EndpointRegistry)service;
                answer = new ManagedEndpointRegistry(context, endpointRegistry);
            } else if (service instanceof BeanIntrospection) {
                BeanIntrospection beanIntrospection = (BeanIntrospection)service;
                answer = new ManagedBeanIntrospection(context, beanIntrospection);
            } else if (service instanceof TypeConverterRegistry) {
                TypeConverterRegistry typeConverterRegistry = (TypeConverterRegistry)service;
                answer = new ManagedTypeConverterRegistry(context, typeConverterRegistry);
            } else if (service instanceof RestRegistry) {
                RestRegistry restRegistry = (RestRegistry)service;
                answer = new ManagedRestRegistry(context, restRegistry);
            } else if (service instanceof EndpointServiceRegistry) {
                EndpointServiceRegistry endpointServiceRegistry = (EndpointServiceRegistry)service;
                answer = new ManagedEndpointServiceRegistry(context, endpointServiceRegistry);
            } else if (service instanceof InflightRepository) {
                InflightRepository inflightRepository = (InflightRepository)service;
                answer = new ManagedInflightRepository(context, inflightRepository);
            } else if (service instanceof AsyncProcessorAwaitManager) {
                AsyncProcessorAwaitManager asyncProcessorAwaitManager = (AsyncProcessorAwaitManager)service;
                answer = new ManagedAsyncProcessorAwaitManager(context, asyncProcessorAwaitManager);
            } else if (service instanceof RuntimeEndpointRegistry) {
                RuntimeEndpointRegistry runtimeEndpointRegistry = (RuntimeEndpointRegistry)service;
                answer = new ManagedRuntimeEndpointRegistry(context, runtimeEndpointRegistry);
            } else if (service instanceof StreamCachingStrategy) {
                StreamCachingStrategy streamCachingStrategy = (StreamCachingStrategy)service;
                answer = new ManagedStreamCachingStrategy(context, streamCachingStrategy);
            } else if (service instanceof ShutdownStrategy) {
                ShutdownStrategy shutdownStrategy = (ShutdownStrategy)service;
                answer = new ManagedShutdownStrategy(context, shutdownStrategy);
            } else if (service instanceof EventNotifier) {
                EventNotifier eventNotifier = (EventNotifier)((Object)service);
                answer = this.getManagementObjectStrategy().getManagedObjectForEventNotifier(context, eventNotifier);
            } else if (service instanceof TransformerRegistry) {
                TransformerRegistry transformerRegistry = (TransformerRegistry)service;
                answer = new ManagedTransformerRegistry(context, transformerRegistry);
            } else if (service instanceof ValidatorRegistry) {
                ValidatorRegistry validatorRegistry = (ValidatorRegistry)service;
                answer = new ManagedValidatorRegistry(context, validatorRegistry);
            } else if (service instanceof BrowsableVariableRepository) {
                BrowsableVariableRepository variableRepository = (BrowsableVariableRepository)service;
                answer = new ManagedVariableRepository(context, variableRepository);
            } else if (service instanceof CamelClusterService) {
                CamelClusterService camelClusterService = (CamelClusterService)service;
                answer = this.getManagementObjectStrategy().getManagedObjectForClusterService(context, camelClusterService);
            } else if (service != null) {
                answer = this.getManagementObjectStrategy().getManagedObjectForService(context, service);
            }
        }
        if (answer instanceof ManagedService) {
            ManagedService ms = (ManagedService)answer;
            ms.setRoute(route);
            ms.init(this.getManagementStrategy());
        }
        return answer;
    }

    private Object getManagedObjectForProcessor(CamelContext context, Processor processor, Route route) {
        ManagementInterceptStrategy.InstrumentationProcessor<?> counter;
        KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor<?>> holder = this.wrappedProcessors.get(processor);
        if (holder == null) {
            return null;
        }
        Object managedObject = this.getManagementObjectStrategy().getManagedObjectForProcessor(context, processor, holder.getKey(), route);
        if (managedObject != null && managedObject instanceof PerformanceCounter && (counter = holder.getValue()) != null) {
            counter.setCounter(managedObject);
        }
        return managedObject;
    }

    @Override
    public void onRoutesAdd(Collection<Route> routes) {
        for (Route route : routes) {
            if (this.getCamelContext().getStatus().isStarting() || this.getManagementStrategy().getManagementAgent().getRegisterAlways().booleanValue() || this.getManagementStrategy().getManagementAgent().getRegisterNewRoutes().booleanValue()) {
                this.knowRouteIds.add(route.getId());
            }
            if (!this.shouldRegister(route, route)) continue;
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (this.getManagementStrategy().isManaged(mr)) {
                LOG.trace("The route is already managed: {}", (Object)route);
                continue;
            }
            Processor processor = route.getProcessor();
            if (processor instanceof InternalProcessor) {
                InternalProcessor internal = (InternalProcessor)processor;
                if (mr instanceof ManagedRoute) {
                    ManagedRoute routeMBean = (ManagedRoute)mr;
                    DefaultInstrumentationProcessor task = internal.getAdvice(DefaultInstrumentationProcessor.class);
                    if (task != null) {
                        if (this.camelContextMBean != null) {
                            CompositePerformanceCounter wrapper = new CompositePerformanceCounter(routeMBean, this.camelContextMBean);
                            task.setCounter(wrapper);
                        } else {
                            task.setCounter(routeMBean);
                        }
                    }
                }
            }
            try {
                this.manageObject(mr);
            }
            catch (JMException e) {
                LOG.warn("Could not register Route MBean", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("Could not create Route MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRoutesRemove(Collection<Route> routes) {
        if (!this.initialized) {
            return;
        }
        for (Route route : routes) {
            Object mr = this.getManagementObjectStrategy().getManagedObjectForRoute(this.camelContext, route);
            if (!this.getManagementStrategy().isManaged(mr)) {
                LOG.trace("The route is not managed: {}", (Object)route);
                continue;
            }
            try {
                this.unmanageObject(mr);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister Route MBean", (Throwable)e);
            }
            this.knowRouteIds.remove(route.getId());
        }
        this.removeWrappedProcessorsForRoutes(routes);
    }

    @Override
    public void onThreadPoolAdd(CamelContext camelContext, ThreadPoolExecutor threadPool, String id, String sourceId, String routeId, String threadPoolProfileId) {
        if (!this.initialized) {
            this.preServices.add(lf -> lf.onThreadPoolAdd(camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId));
            return;
        }
        if (!this.shouldRegister(threadPool, null)) {
            return;
        }
        Object mtp = this.getManagementObjectStrategy().getManagedObjectForThreadPool(camelContext, threadPool, id, sourceId, routeId, threadPoolProfileId);
        if (this.getManagementStrategy().isManaged(mtp)) {
            LOG.trace("The thread pool is already managed: {}", (Object)threadPool);
            return;
        }
        try {
            this.manageObject(mtp);
            this.managedThreadPools.put(threadPool, mtp);
        }
        catch (Exception e) {
            LOG.warn("Could not register thread pool: {} as ThreadPool MBean.", (Object)threadPool, (Object)e);
        }
    }

    @Override
    public void onThreadPoolRemove(CamelContext camelContext, ThreadPoolExecutor threadPool) {
        if (!this.initialized) {
            return;
        }
        Object mtp = this.managedThreadPools.remove(threadPool);
        if (mtp != null) {
            if (!this.getManagementStrategy().isManaged(mtp)) {
                LOG.trace("The thread pool is not managed: {}", (Object)threadPool);
                return;
            }
            try {
                this.unmanageObject(mtp);
            }
            catch (Exception e) {
                LOG.warn("Could not unregister ThreadPool MBean", (Throwable)e);
            }
        }
    }

    @Override
    public void onRouteContextCreate(Route route) {
        HashMap<NamedNode, PerformanceCounter> registeredCounters = new HashMap<NamedNode, PerformanceCounter>();
        RouteDefinition routeDefinition = (RouteDefinition)route.getRoute();
        for (ProcessorDefinition<?> processor : routeDefinition.getOutputs()) {
            this.registerPerformanceCounters(route, processor, registeredCounters);
        }
        route.setManagementInterceptStrategy(new InstrumentationInterceptStrategy(registeredCounters, this.wrappedProcessors));
    }

    private void removeWrappedProcessorsForRoutes(Collection<Route> routes) {
        for (Route route : routes) {
            String id = route.getId();
            Iterator<KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor<?>>> it = this.wrappedProcessors.values().iterator();
            while (it.hasNext()) {
                KeyValueHolder<NamedNode, ManagementInterceptStrategy.InstrumentationProcessor<?>> holder = it.next();
                RouteDefinition def = ProcessorDefinitionHelper.getRoute(holder.getKey());
                if (def == null || !id.equals(def.getId())) continue;
                it.remove();
            }
        }
    }

    private void registerPerformanceCounters(Route route, ProcessorDefinition<?> processor, Map<NamedNode, PerformanceCounter> registeredCounters) {
        List<ProcessorDefinition<?>> children = processor.getOutputs();
        for (ProcessorDefinition<?> child : children) {
            this.registerPerformanceCounters(route, child, registeredCounters);
        }
        if (!this.registerProcessor(processor)) {
            return;
        }
        DelegatePerformanceCounter pc = new DelegatePerformanceCounter();
        boolean enabled = this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isDefaultOrExtended();
        pc.setStatisticsEnabled(enabled);
        registeredCounters.put(processor, pc);
    }

    protected boolean registerProcessor(ProcessorDefinition<?> processor) {
        boolean only;
        if (!this.getManagementStrategy().getManagementAgent().getMBeansLevel().isProcessors()) {
            return false;
        }
        if (processor instanceof OnExceptionDefinition) {
            return false;
        }
        if (processor instanceof OnCompletionDefinition) {
            return false;
        }
        if (processor instanceof InterceptDefinition) {
            return false;
        }
        if (processor instanceof PolicyDefinition) {
            return false;
        }
        boolean bl = only = this.getManagementStrategy().getManagementAgent().getOnlyRegisterProcessorWithCustomId() != null && this.getManagementStrategy().getManagementAgent().getOnlyRegisterProcessorWithCustomId() != false;
        if (only) {
            return processor.hasCustomIdAssigned();
        }
        return this.getManagementStrategy().manageProcessor(processor);
    }

    private ManagementStrategy getManagementStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy();
    }

    private ManagementObjectStrategy getManagementObjectStrategy() {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        return this.camelContext.getManagementStrategy().getManagementObjectStrategy();
    }

    protected void manageObject(Object me) throws Exception {
        this.getManagementStrategy().manageObject(me);
        if (me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.loadTimer.addTimerListener(timer);
        }
    }

    protected void unmanageObject(Object me) throws Exception {
        if (me instanceof TimerListener) {
            TimerListener timer = (TimerListener)me;
            this.loadTimer.removeTimerListener(timer);
        }
        this.getManagementStrategy().unmanageObject(me);
    }

    protected boolean shouldRegister(Object service, Route route) {
        if (!this.initialized) {
            return false;
        }
        LOG.trace("Checking whether to register {} from route: {}", service, (Object)route);
        if (!this.getManagementStrategy().getManagementAgent().getMBeansLevel().isRoutes()) {
            return false;
        }
        ManagementAgent agent = this.getManagementStrategy().getManagementAgent();
        if (agent == null) {
            return false;
        }
        if (route != null && route.isCreatedByKamelet() && !agent.getRegisterRoutesCreateByKamelet().booleanValue()) {
            return false;
        }
        if (route != null && route.isCreatedByRouteTemplate() && !agent.getRegisterRoutesCreateByTemplate().booleanValue()) {
            return false;
        }
        if (this.getCamelContext().getStatus().isStarting() || this.getCamelContext().getStatus().isInitializing()) {
            return true;
        }
        if (this.getCamelContext().getCamelContextExtension().isSetupRoutes()) {
            return true;
        }
        if (agent.getRegisterAlways().booleanValue()) {
            return true;
        }
        if (route != null && this.knowRouteIds.contains(route.getId())) {
            return true;
        }
        if (agent.getRegisterNewRoutes().booleanValue()) {
            return this.getCamelContext().getRouteController().isStartingRoutes();
        }
        return false;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.camelContext, "CamelContext");
        this.camelContext.addStartupListener(this.loadTimerStartupListener);
    }

    @Override
    protected void doStop() throws Exception {
        this.initialized = false;
        this.knowRouteIds.clear();
        this.preServices.clear();
        this.wrappedProcessors.clear();
        this.managedBacklogTracers.clear();
        this.managedBacklogDebuggers.clear();
        this.managedThreadPools.clear();
    }

    private final class TimerListenerManagerStartupListener
    implements StartupListener {
        private TimerListenerManagerStartupListener() {
        }

        @Override
        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
            boolean load = JmxManagementLifecycleStrategy.this.camelContext.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != null && JmxManagementLifecycleStrategy.this.camelContext.getManagementStrategy().getManagementAgent().getLoadStatisticsEnabled() != false;
            boolean disabled = !load || JmxManagementLifecycleStrategy.this.camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel() == ManagementStatisticsLevel.Off;
            LOG.debug("Load performance statistics {}", (Object)(disabled ? "disabled" : "enabled"));
            if (!disabled) {
                JmxManagementLifecycleStrategy.this.loadTimer.setInterval(1000L);
                JmxManagementLifecycleStrategy.this.getCamelContext().addService(JmxManagementLifecycleStrategy.this.loadTimer);
            }
        }
    }
}

