/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.MessageHistory;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBacklogDebuggerMBean;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.LoggerHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed BacklogDebugger")
public class ManagedBacklogDebugger
implements ManagedBacklogDebuggerMBean {
    private final CamelContext camelContext;
    private final DefaultBacklogDebugger backlogDebugger;

    public ManagedBacklogDebugger(CamelContext camelContext, DefaultBacklogDebugger backlogDebugger) {
        this.camelContext = camelContext;
        this.backlogDebugger = backlogDebugger;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public DefaultBacklogDebugger getBacklogDebugger() {
        return this.backlogDebugger;
    }

    @Override
    public String getCamelId() {
        return this.camelContext.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    @Override
    public String getLoggingLevel() {
        return this.backlogDebugger.getLoggingLevel();
    }

    @Override
    public void setLoggingLevel(String level) {
        this.backlogDebugger.setLoggingLevel(level);
    }

    @Override
    public boolean isEnabled() {
        return this.backlogDebugger.isEnabled();
    }

    @Override
    public boolean isStandby() {
        return this.backlogDebugger.isStandby();
    }

    @Override
    public void enableDebugger() {
        this.backlogDebugger.enableDebugger();
    }

    @Override
    public void disableDebugger() {
        this.backlogDebugger.disableDebugger();
    }

    @Override
    public void addBreakpoint(String nodeId) {
        this.backlogDebugger.addBreakpoint(nodeId);
    }

    @Override
    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        this.backlogDebugger.addConditionalBreakpoint(nodeId, language, predicate);
    }

    @Override
    public void removeBreakpoint(String nodeId) {
        this.backlogDebugger.removeBreakpoint(nodeId);
    }

    @Override
    public void removeAllBreakpoints() {
        this.backlogDebugger.removeAllBreakpoints();
    }

    @Override
    public Set<String> breakpoints() {
        return this.backlogDebugger.getBreakpoints();
    }

    @Override
    public void resumeBreakpoint(String nodeId) {
        this.backlogDebugger.resumeBreakpoint(nodeId);
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body);
    }

    @Override
    public void setMessageBodyOnBreakpoint(String nodeId, Object body, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body, classType);
        }
        catch (ClassNotFoundException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeMessageBodyOnBreakpoint(String nodeId) {
        this.backlogDebugger.removeMessageBodyOnBreakpoint(nodeId);
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) {
        try {
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value, classType);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        this.backlogDebugger.removeMessageHeaderOnBreakpoint(nodeId, headerName);
    }

    @Override
    public void resumeAll() {
        this.backlogDebugger.resumeAll();
    }

    @Override
    public void stepBreakpoint(String nodeId) {
        this.backlogDebugger.stepBreakpoint(nodeId);
    }

    @Override
    public boolean isSuspendedMode() {
        return this.backlogDebugger.isSuspendMode();
    }

    @Override
    public boolean isSingleStepMode() {
        return this.backlogDebugger.isSingleStepMode();
    }

    @Override
    public void step() {
        this.backlogDebugger.step();
    }

    @Override
    public Set<String> suspendedBreakpointNodeIds() {
        return this.backlogDebugger.getSuspendedBreakpointNodeIds();
    }

    @Override
    public void disableBreakpoint(String nodeId) {
        this.backlogDebugger.disableBreakpoint(nodeId);
    }

    @Override
    public void enableBreakpoint(String nodeId) {
        this.backlogDebugger.enableBreakpoint(nodeId);
    }

    @Override
    public int getBodyMaxChars() {
        return this.backlogDebugger.getBodyMaxChars();
    }

    @Override
    public void setBodyMaxChars(int bodyMaxChars) {
        this.backlogDebugger.setBodyMaxChars(bodyMaxChars);
    }

    @Override
    public boolean isIncludeExchangeProperties() {
        return this.backlogDebugger.isIncludeExchangeProperties();
    }

    @Override
    public void setIncludeExchangeProperties(boolean includeExchangeProperties) {
        this.backlogDebugger.setIncludeExchangeProperties(includeExchangeProperties);
    }

    @Override
    public boolean isIncludeExchangeVariables() {
        return this.backlogDebugger.isIncludeExchangeVariables();
    }

    @Override
    public void setIncludeExchangeVariables(boolean includeExchangeVariables) {
        this.backlogDebugger.setIncludeExchangeVariables(includeExchangeVariables);
    }

    @Override
    public boolean isBodyIncludeStreams() {
        return this.backlogDebugger.isBodyIncludeStreams();
    }

    @Override
    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.backlogDebugger.setBodyIncludeStreams(bodyIncludeStreams);
    }

    @Override
    public boolean isBodyIncludeFiles() {
        return this.backlogDebugger.isBodyIncludeFiles();
    }

    @Override
    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.backlogDebugger.setBodyIncludeFiles(bodyIncludeFiles);
    }

    @Override
    public String dumpTracedMessagesAsXml(String nodeId) {
        return this.backlogDebugger.dumpTracedMessagesAsXml(nodeId);
    }

    @Override
    @Deprecated(since="4.2.0")
    public String dumpTracedMessagesAsXml(String nodeId, boolean includeExchangeProperties) {
        return this.dumpTracedMessagesAsXml(nodeId);
    }

    @Override
    public String dumpTracedMessagesAsJSon(String nodeId) {
        return this.backlogDebugger.dumpTracedMessagesAsJSon(nodeId);
    }

    @Override
    public long getDebugCounter() {
        return this.backlogDebugger.getDebugCounter();
    }

    @Override
    public void resetDebugCounter() {
        this.backlogDebugger.resetDebugCounter();
    }

    @Override
    public String validateConditionalBreakpoint(String language, String predicate) {
        Language lan = null;
        try {
            lan = this.camelContext.resolveLanguage(language);
            lan.createPredicate(predicate);
            return null;
        }
        catch (Exception e) {
            if (lan == null) {
                return e.getMessage();
            }
            return "Invalid syntax " + predicate + " due: " + e.getMessage();
        }
    }

    @Override
    public long getFallbackTimeout() {
        return this.backlogDebugger.getFallbackTimeout();
    }

    @Override
    public void setFallbackTimeout(long fallbackTimeout) {
        this.backlogDebugger.setFallbackTimeout(fallbackTimeout);
    }

    @Override
    public String evaluateExpressionAtBreakpoint(String nodeId, String language, String expression) {
        return this.evaluateExpressionAtBreakpoint(nodeId, language, expression, "java.lang.String").toString();
    }

    @Override
    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value) {
        try {
            this.backlogDebugger.setExchangePropertyOnBreakpoint(nodeId, exchangePropertyName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void setExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName, Object value, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setExchangePropertyOnBreakpoint(nodeId, exchangePropertyName, value, classType);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeExchangePropertyOnBreakpoint(String nodeId, String exchangePropertyName) {
        this.backlogDebugger.removeExchangePropertyOnBreakpoint(nodeId, exchangePropertyName);
    }

    @Override
    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value) {
        try {
            this.backlogDebugger.setExchangeVariableOnBreakpoint(nodeId, variableName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void setExchangeVariableOnBreakpoint(String nodeId, String variableName, Object value, String type) {
        try {
            Class<?> classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setExchangeVariableOnBreakpoint(nodeId, variableName, value, classType);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public void removeExchangeVariableOnBreakpoint(String nodeId, String variableName) {
        this.backlogDebugger.removeExchangeVariableOnBreakpoint(nodeId, variableName);
    }

    @Override
    public Object evaluateExpressionAtBreakpoint(String nodeId, String language, String expression, String resultType) {
        try {
            Language lan = this.camelContext.resolveLanguage(language);
            Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
            if (suspendedExchange != null) {
                String resultStr;
                Object result;
                Class<?> resultClass = this.camelContext.getClassResolver().resolveMandatoryClass(resultType);
                if (!Boolean.class.isAssignableFrom(resultClass)) {
                    Expression expr = lan.createExpression(expression);
                    expr.init(this.camelContext);
                    result = expr.evaluate(suspendedExchange, resultClass);
                } else {
                    Predicate pred = lan.createPredicate(expression);
                    pred.init(this.camelContext);
                    result = pred.matches(suspendedExchange);
                }
                if (!ManagedBacklogDebugger.isSerializable(result) && (resultStr = suspendedExchange.getContext().getTypeConverter().tryConvertTo(String.class, result)) != null) {
                    result = resultStr;
                }
                return result;
            }
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    @Override
    public String messageHistoryOnBreakpointAsXml(String nodeId) {
        List list;
        StringBuilder messageHistoryBuilder = new StringBuilder();
        messageHistoryBuilder.append("<messageHistory>\n");
        Exchange suspendedExchange = this.backlogDebugger.getSuspendedExchange(nodeId);
        if (suspendedExchange != null && (list = suspendedExchange.getProperty(ExchangePropertyKey.MESSAGE_HISTORY, List.class)) != null) {
            String routeId = suspendedExchange.getFromRouteId();
            Route route = suspendedExchange.getContext().getRoute(routeId);
            String loc = route != null ? route.getSourceLocationShort() : "";
            String id = routeId;
            Object label = "";
            if (suspendedExchange.getFromEndpoint() != null) {
                label = "from[" + URISupport.sanitizeUri(StringHelper.limitLength(suspendedExchange.getFromEndpoint().getEndpointUri(), 100)) + "]";
            }
            long elapsed = suspendedExchange.getClock().elapsed();
            messageHistoryBuilder.append("    <messageHistoryEntry").append(" location=\"").append(StringHelper.xmlEncode(loc)).append("\"").append(" routeId=\"").append(StringHelper.xmlEncode(routeId)).append("\"").append(" processorId=\"").append(StringHelper.xmlEncode(id)).append("\"").append(" processor=\"").append(StringHelper.xmlEncode((String)label)).append("\"").append(" elapsed=\"").append(elapsed).append("\"").append("/>\n");
            for (MessageHistory history : list) {
                loc = LoggerHelper.getLineNumberLoggerName(history.getNode());
                if (loc == null) {
                    loc = "";
                }
                routeId = history.getRouteId() != null ? history.getRouteId() : "";
                id = history.getNode().getId();
                label = URISupport.sanitizeUri(StringHelper.limitLength(history.getNode().getLabel(), 100));
                elapsed = history.getElapsed();
                messageHistoryBuilder.append("    <messageHistoryEntry").append(" location=\"").append(StringHelper.xmlEncode(loc)).append("\"").append(" routeId=\"").append(StringHelper.xmlEncode(routeId)).append("\"").append(" processorId=\"").append(StringHelper.xmlEncode(id)).append("\"").append(" processor=\"").append(StringHelper.xmlEncode((String)label)).append("\"").append(" elapsed=\"").append(elapsed).append("\"").append("/>\n");
            }
        }
        messageHistoryBuilder.append("</messageHistory>\n");
        return messageHistoryBuilder.toString();
    }

    @Override
    public void attach() {
        this.backlogDebugger.attach();
    }

    @Override
    public void detach() {
        this.backlogDebugger.detach();
    }

    private static boolean isSerializable(Object obj) {
        boolean bl;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ObjectOutputStream out = new ObjectOutputStream(baos);
        try {
            out.writeObject(obj);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        out.close();
        return bl;
    }
}

