/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBrowsableEndpointMBean;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.support.MessageHelper;

@ManagedResource(description="Managed BrowsableEndpoint")
public class ManagedBrowsableEndpoint
extends ManagedEndpoint
implements ManagedBrowsableEndpointMBean {
    public ManagedBrowsableEndpoint(BrowsableEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public BrowsableEndpoint getEndpoint() {
        return (BrowsableEndpoint)super.getEndpoint();
    }

    @Override
    public BrowsableEndpoint getInstance() {
        return this.getEndpoint();
    }

    @Override
    public long queueSize() {
        return this.getEndpoint().getExchanges().size();
    }

    @Override
    public String browseExchange(Integer index) {
        List<Exchange> exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.toString();
    }

    @Override
    public String browseMessageBody(Integer index) {
        List<Exchange> exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        return exchange.getMessage().getBody(String.class);
    }

    @Override
    public String browseMessageAsXml(Integer index, Boolean includeBody) {
        List<Exchange> exchanges = this.getEndpoint().getExchanges();
        if (index >= exchanges.size()) {
            return null;
        }
        Exchange exchange = exchanges.get(index);
        if (exchange == null) {
            return null;
        }
        Message msg = exchange.getMessage();
        return MessageHelper.dumpAsXml(msg, includeBody);
    }

    @Override
    public String browseAllMessagesAsXml(Boolean includeBody) {
        return this.browseRangeMessagesAsXml(0, Integer.MAX_VALUE, includeBody);
    }

    @Override
    public String browseRangeMessagesAsXml(Integer fromIndex, Integer toIndex, Boolean includeBody) {
        if (fromIndex == null) {
            fromIndex = 0;
        }
        if (toIndex == null) {
            toIndex = Integer.MAX_VALUE;
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("From index cannot be larger than to index, was: " + fromIndex + " > " + toIndex);
        }
        List<Exchange> exchanges = this.getEndpoint().getExchanges();
        if (exchanges.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<messages>");
        for (int i = fromIndex.intValue(); i < exchanges.size() && i <= toIndex; ++i) {
            Exchange exchange = exchanges.get(i);
            Message msg = exchange.getMessage();
            String xml = MessageHelper.dumpAsXml(msg, includeBody);
            sb.append("\n").append(xml);
        }
        sb.append("\n</messages>");
        return sb.toString();
    }
}

