/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedEndpointServiceRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed EndpointServiceRegistry")
public class ManagedEndpointServiceRegistry
extends ManagedService
implements ManagedEndpointServiceRegistryMBean {
    private final EndpointServiceRegistry registry;
    private boolean sanitize;

    public ManagedEndpointServiceRegistry(CamelContext context, EndpointServiceRegistry registry) {
        super(context, registry);
        this.registry = registry;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
    }

    public EndpointServiceRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public int getNumberOfEndpointServices() {
        return this.registry.size();
    }

    @Override
    public TabularData listEndpointServices() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listEndpointServicesTabularType());
            List<EndpointServiceRegistry.EndpointService> services = this.registry.listAllEndpointServices();
            for (EndpointServiceRegistry.EndpointService entry : services) {
                CompositeType ct = CamelOpenMBeanTypes.listEndpointServicesCompositeType();
                String component = entry.getComponent();
                String dir = entry.getDirection();
                String protocol = entry.getServiceProtocol();
                String serviceUrl = entry.getServiceUrl();
                String metadata = null;
                String endpointUri = entry.getEndpointUri();
                if (this.sanitize) {
                    endpointUri = URISupport.sanitizeUri(endpointUri);
                }
                long hits = entry.getHits();
                String routeId = entry.getRouteId();
                Map<String, String> m = entry.getServiceMetadata();
                if (m != null) {
                    StringJoiner sj = new StringJoiner(" ");
                    m.forEach((k, v) -> sj.add(k + "=" + v));
                    metadata = sj.toString();
                }
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"component", "dir", "protocol", "serviceUrl", "metadata", "endpointUri", "routeId", "hits"}, new Object[]{component, dir, protocol, serviceUrl, metadata, endpointUri, routeId, hits});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

