/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedShutdownStrategyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ShutdownStrategy;

@ManagedResource(description="Managed ShutdownStrategy")
public class ManagedShutdownStrategy
extends ManagedService
implements ManagedShutdownStrategyMBean {
    private final ShutdownStrategy strategy;

    public ManagedShutdownStrategy(CamelContext context, ShutdownStrategy controller) {
        super(context, controller);
        this.strategy = controller;
    }

    public ShutdownStrategy getShutdownStrategy() {
        return this.strategy;
    }

    @Override
    public void setTimeout(long timeout) {
        this.strategy.setTimeout(timeout);
    }

    @Override
    public long getTimeout() {
        return this.strategy.getTimeout();
    }

    @Override
    public void setTimeUnit(TimeUnit timeUnit) {
        this.strategy.setTimeUnit(timeUnit);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.strategy.getTimeUnit();
    }

    @Override
    public void setSuppressLoggingOnTimeout(boolean suppressLoggingOnTimeout) {
        this.strategy.setSuppressLoggingOnTimeout(suppressLoggingOnTimeout);
    }

    @Override
    public boolean isSuppressLoggingOnTimeout() {
        return this.strategy.isSuppressLoggingOnTimeout();
    }

    @Override
    public void setShutdownNowOnTimeout(boolean shutdownNowOnTimeout) {
        this.strategy.setShutdownNowOnTimeout(shutdownNowOnTimeout);
    }

    @Override
    public boolean isShutdownNowOnTimeout() {
        return this.strategy.isShutdownNowOnTimeout();
    }

    @Override
    public void setShutdownRoutesInReverseOrder(boolean shutdownRoutesInReverseOrder) {
        this.strategy.setShutdownRoutesInReverseOrder(shutdownRoutesInReverseOrder);
    }

    @Override
    public boolean isShutdownRoutesInReverseOrder() {
        return this.strategy.isShutdownRoutesInReverseOrder();
    }

    @Override
    public void setLogInflightExchangesOnTimeout(boolean logInflightExchangesOnTimeout) {
        this.strategy.setLogInflightExchangesOnTimeout(logInflightExchangesOnTimeout);
    }

    @Override
    public boolean isLogInflightExchangesOnTimeout() {
        return this.strategy.isLogInflightExchangesOnTimeout();
    }

    @Override
    public boolean isForceShutdown() {
        return this.strategy.isForceShutdown();
    }

    @Override
    public boolean isTimeoutOccurred() {
        return this.strategy.isTimeoutOccurred();
    }

    @Override
    public String getLoggingLevel() {
        return this.strategy.getLoggingLevel().toString();
    }

    @Override
    public void setLoggingLevel(String loggingLevel) {
        this.strategy.setLoggingLevel(LoggingLevel.valueOf(loggingLevel));
    }
}

