/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedStreamCachingStrategyMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.StreamCachingStrategy;

@ManagedResource(description="Managed StreamCachingStrategy")
public class ManagedStreamCachingStrategy
extends ManagedService
implements ManagedStreamCachingStrategyMBean {
    private final CamelContext camelContext;
    private final StreamCachingStrategy streamCachingStrategy;
    private final String[] allowClasses;
    private final String[] denyClasses;

    public ManagedStreamCachingStrategy(CamelContext camelContext, StreamCachingStrategy streamCachingStrategy) {
        super(camelContext, streamCachingStrategy);
        this.camelContext = camelContext;
        this.streamCachingStrategy = streamCachingStrategy;
        this.allowClasses = streamCachingStrategy.getAllowClasses() != null ? (String[])streamCachingStrategy.getAllowClasses().stream().map(Class::getName).toArray(String[]::new) : null;
        this.denyClasses = streamCachingStrategy.getDenyClasses() != null ? (String[])streamCachingStrategy.getDenyClasses().stream().map(Class::getName).toArray(String[]::new) : null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public StreamCachingStrategy getStreamCachingStrategy() {
        return this.streamCachingStrategy;
    }

    @Override
    public boolean isEnabled() {
        return this.streamCachingStrategy.isEnabled();
    }

    @Override
    public String[] getAllowClasses() {
        return this.allowClasses;
    }

    @Override
    public String[] getDenyClasses() {
        return this.denyClasses;
    }

    @Override
    public boolean isSpoolEnabled() {
        return this.streamCachingStrategy.isSpoolEnabled();
    }

    @Override
    public String getSpoolDirectory() {
        if (this.streamCachingStrategy.getSpoolDirectory() != null) {
            return this.streamCachingStrategy.getSpoolDirectory().getPath();
        }
        return null;
    }

    @Override
    public String getSpoolCipher() {
        return this.streamCachingStrategy.getSpoolCipher();
    }

    @Override
    public void setSpoolThreshold(long threshold) {
        this.streamCachingStrategy.setSpoolThreshold(threshold);
    }

    @Override
    public long getSpoolThreshold() {
        return this.streamCachingStrategy.getSpoolThreshold();
    }

    @Override
    public void setSpoolUsedHeapMemoryThreshold(int percentage) {
        this.streamCachingStrategy.setSpoolUsedHeapMemoryThreshold(percentage);
    }

    @Override
    public int getSpoolUsedHeapMemoryThreshold() {
        return this.streamCachingStrategy.getSpoolUsedHeapMemoryThreshold();
    }

    @Override
    public void setSpoolUsedHeapMemoryLimit(ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit limit) {
        StreamCachingStrategy.SpoolUsedHeapMemoryLimit l;
        if (limit == null) {
            l = null;
        } else {
            l = switch (limit) {
                default -> throw new IncompatibleClassChangeError();
                case ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Committed -> StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
                case ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Max -> StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            };
        }
        this.streamCachingStrategy.setSpoolUsedHeapMemoryLimit(l);
    }

    @Override
    public ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit getSpoolUsedHeapMemoryLimit() {
        StreamCachingStrategy.SpoolUsedHeapMemoryLimit l = this.streamCachingStrategy.getSpoolUsedHeapMemoryLimit();
        if (l == null) {
            return null;
        }
        return switch (l) {
            default -> throw new IncompatibleClassChangeError();
            case StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed -> ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Committed;
            case StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max -> ManagedStreamCachingStrategyMBean.SpoolUsedHeapMemoryLimit.Max;
        };
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.streamCachingStrategy.setBufferSize(bufferSize);
    }

    @Override
    public int getBufferSize() {
        return this.streamCachingStrategy.getBufferSize();
    }

    @Override
    public void setRemoveSpoolDirectoryWhenStopping(boolean remove) {
        this.streamCachingStrategy.setRemoveSpoolDirectoryWhenStopping(remove);
    }

    @Override
    public boolean isRemoveSpoolDirectoryWhenStopping() {
        return this.streamCachingStrategy.isRemoveSpoolDirectoryWhenStopping();
    }

    @Override
    public void setAnySpoolRules(boolean any) {
        this.streamCachingStrategy.setAnySpoolRules(any);
    }

    @Override
    public boolean isAnySpoolRules() {
        return this.streamCachingStrategy.isAnySpoolRules();
    }

    @Override
    public long getCacheMemoryCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryCounter();
    }

    @Override
    public long getCacheMemorySize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemorySize();
    }

    @Override
    public long getCacheMemoryAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheMemoryAverageSize();
    }

    @Override
    public long getCacheSpoolCounter() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolCounter();
    }

    @Override
    public long getCacheSpoolSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolSize();
    }

    @Override
    public long getCacheSpoolAverageSize() {
        return this.streamCachingStrategy.getStatistics().getCacheSpoolAverageSize();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.streamCachingStrategy.getStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.streamCachingStrategy.getStatistics().setStatisticsEnabled(enabled);
    }

    @Override
    public void resetStatistics() {
        this.streamCachingStrategy.getStatistics().reset();
    }
}

