/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedSuspendableRouteMBean;
import org.apache.camel.management.mbean.ManagedRoute;

@ManagedResource(description="Managed Suspendable Route")
public class ManagedSuspendableRoute
extends ManagedRoute
implements ManagedSuspendableRouteMBean {
    public ManagedSuspendableRoute(CamelContext context, Route route) {
        super(context, route);
    }

    @Override
    public void suspend() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().suspendRoute(this.getRouteId());
    }

    @Override
    public void suspend(long timeout) throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().suspendRoute(this.getRouteId(), timeout, TimeUnit.SECONDS);
    }

    @Override
    public void resume() throws Exception {
        if (!this.context.getStatus().isStarted()) {
            throw new IllegalArgumentException("CamelContext is not started");
        }
        this.context.getRouteController().resumeRoute(this.getRouteId());
    }
}

