/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedThrottlerMBean;
import org.apache.camel.builder.Builder;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.TotalRequestsThrottler;

@ManagedResource(description="Managed Concurrent Requests Throttler")
public class ManagedThrottler
extends ManagedProcessor
implements ManagedThrottlerMBean {
    private final Throttler throttler;

    public ManagedThrottler(CamelContext context, Throttler throttler, ProcessorDefinition<?> definition) {
        super(context, throttler, definition);
        this.throttler = throttler;
    }

    public Throttler getThrottler() {
        return this.throttler;
    }

    @Override
    public long getMaximumRequests() {
        return this.throttler.getCurrentMaximumRequests();
    }

    @Override
    public void setMaximumRequests(long maximumConcurrentRequests) {
        this.throttler.setMaximumRequestsExpression(Builder.constant(maximumConcurrentRequests));
    }

    @Override
    public long getTimePeriodMillis() {
        Throttler throttler = this.throttler;
        if (throttler instanceof TotalRequestsThrottler) {
            TotalRequestsThrottler t = (TotalRequestsThrottler)throttler;
            return t.getTimePeriodMillis();
        }
        return 0L;
    }

    @Override
    public void setTimePeriodMillis(long timePeriodMillis) {
        Throttler throttler = this.throttler;
        if (throttler instanceof TotalRequestsThrottler) {
            TotalRequestsThrottler t = (TotalRequestsThrottler)throttler;
            t.setTimePeriodMillis(timePeriodMillis);
        }
    }

    @Override
    public String getMode() {
        return this.throttler.getMode();
    }

    @Override
    public Boolean isAsyncDelayed() {
        return this.throttler.isAsyncDelayed();
    }

    @Override
    public Boolean isCallerRunsWhenRejected() {
        return this.throttler.isCallerRunsWhenRejected();
    }

    @Override
    public Boolean isRejectExecution() {
        return this.throttler.isRejectExecution();
    }
}

