/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedTypeConverterRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.TypeConverterRegistry;

@ManagedResource(description="Managed TypeConverterRegistry")
public class ManagedTypeConverterRegistry
extends ManagedService
implements ManagedTypeConverterRegistryMBean {
    private final TypeConverterRegistry registry;

    public ManagedTypeConverterRegistry(CamelContext context, TypeConverterRegistry registry) {
        super(context, registry);
        this.registry = registry;
    }

    public TypeConverterRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public long getNoopCounter() {
        return this.registry.getStatistics().getNoopCounter();
    }

    @Override
    public long getAttemptCounter() {
        return this.registry.getStatistics().getAttemptCounter();
    }

    @Override
    public long getHitCounter() {
        return this.registry.getStatistics().getHitCounter();
    }

    @Override
    public long getMissCounter() {
        return this.registry.getStatistics().getMissCounter();
    }

    @Override
    public long getFailedCounter() {
        return this.registry.getStatistics().getFailedCounter();
    }

    @Override
    public void resetTypeConversionCounters() {
        this.registry.getStatistics().reset();
    }

    @Override
    public int getNumberOfTypeConverters() {
        return this.registry.size();
    }

    @Override
    public String getTypeConverterExistsLoggingLevel() {
        return this.registry.getTypeConverterExistsLoggingLevel().name();
    }

    @Override
    public String getTypeConverterExists() {
        return this.registry.getTypeConverterExists().name();
    }

    @Override
    public boolean hasTypeConverter(String fromType, String toType) {
        try {
            Class<?> from = this.getContext().getClassResolver().resolveMandatoryClass(fromType);
            Class<?> to = this.getContext().getClassResolver().resolveMandatoryClass(toType);
            return this.registry.lookup(to, from) != null;
        }
        catch (ClassNotFoundException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

