/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnCompletionMode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.OnCompletionProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.InternalProcessor;
import org.apache.camel.support.PluginHelper;

public class OnCompletionReifier
extends ProcessorReifier<OnCompletionDefinition> {
    public OnCompletionReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (OnCompletionDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean isOnCompleteOnly = this.parseBoolean(((OnCompletionDefinition)this.definition).getOnCompleteOnly(), false);
        boolean isOnFailureOnly = this.parseBoolean(((OnCompletionDefinition)this.definition).getOnFailureOnly(), false);
        boolean isParallelProcessing = this.parseBoolean(((OnCompletionDefinition)this.definition).getParallelProcessing(), false);
        boolean original = this.parseBoolean(((OnCompletionDefinition)this.definition).getUseOriginalMessage(), false);
        if (isOnCompleteOnly && isOnFailureOnly) {
            throw new IllegalArgumentException("Both onCompleteOnly and onFailureOnly cannot be true. Only one of them can be true. On node: " + String.valueOf(this));
        }
        if (original) {
            this.route.setAllowUseOriginalMessage(true);
        }
        Processor childProcessor = this.createChildProcessor(true);
        InternalProcessor target = PluginHelper.getInternalProcessorFactory(this.camelContext).addUnitOfWorkProcessorAdvice(this.camelContext, childProcessor, this.route);
        this.route.setOnCompletion(this.getId(this.definition), target);
        Predicate when = null;
        if (((OnCompletionDefinition)this.definition).getOnWhen() != null) {
            when = this.createPredicate(((OnCompletionDefinition)this.definition).getOnWhen().getExpression());
        }
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("OnCompletion", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        boolean afterConsumer = ((OnCompletionDefinition)this.definition).getMode() == null || this.parse(OnCompletionMode.class, ((OnCompletionDefinition)this.definition).getMode()) == OnCompletionMode.AfterConsumer;
        return new OnCompletionProcessor(this.camelContext, target, threadPool, shutdownThreadPool, isOnCompleteOnly, isOnFailureOnly, when, original, afterConsumer, ((OnCompletionDefinition)this.definition).isRouteScoped());
    }
}

