/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedCamelContext;
import org.apache.camel.api.management.mbean.ManagedCamelContextMBean;
import org.apache.camel.api.management.mbean.ManagedConsumerMBean;
import org.apache.camel.api.management.mbean.ManagedProcessorMBean;
import org.apache.camel.api.management.mbean.ManagedRouteMBean;
import org.apache.camel.api.management.mbean.ManagedStepMBean;
import org.apache.camel.model.Model;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ManagementStrategy;

public class ManagedCamelContextImpl
implements ManagedCamelContext {
    private final CamelContext camelContext;

    public ManagedCamelContextImpl(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    private ManagementStrategy getManagementStrategy() {
        return this.camelContext.getManagementStrategy();
    }

    @Override
    public <T extends ManagedProcessorMBean> T getManagedProcessor(String id, Class<T> type) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Processor processor = this.camelContext.getProcessor(id);
        ProcessorDefinition<?> def = this.camelContext.getCamelContextExtension().getContextPlugin(Model.class).getProcessorDefinition(id);
        if (def != null) {
            try {
                ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForProcessor(this.camelContext, processor, def);
                return (T)((ManagedProcessorMBean)this.getManagementStrategy().getManagementAgent().newProxyClient(on, type));
            }
            catch (MalformedObjectNameException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public ManagedStepMBean getManagedStep(String id) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Processor processor = this.camelContext.getProcessor(id);
        ProcessorDefinition<?> def = this.camelContext.getCamelContextExtension().getContextPlugin(Model.class).getProcessorDefinition(id);
        if (def != null) {
            try {
                ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForStep(this.camelContext, processor, def);
                return this.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedStepMBean.class);
            }
            catch (MalformedObjectNameException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public <T extends ManagedRouteMBean> T getManagedRoute(String routeId, Class<T> type) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Route route = this.camelContext.getRoute(routeId);
        if (route != null) {
            try {
                ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForRoute(route);
                return (T)((ManagedRouteMBean)this.getManagementStrategy().getManagementAgent().newProxyClient(on, type));
            }
            catch (MalformedObjectNameException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public <T extends ManagedConsumerMBean> T getManagedConsumer(String id, Class<T> type) {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        Route route = this.camelContext.getRoute(id);
        if (route != null) {
            try {
                Consumer consumer = route.getConsumer();
                ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForConsumer(this.camelContext, consumer);
                return (T)((ManagedConsumerMBean)this.getManagementStrategy().getManagementAgent().newProxyClient(on, type));
            }
            catch (MalformedObjectNameException e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
        return null;
    }

    @Override
    public ManagedCamelContextMBean getManagedCamelContext() {
        if (this.getManagementStrategy().getManagementAgent() == null) {
            return null;
        }
        if (this.getManagementStrategy().getManagementObjectNameStrategy() == null) {
            return null;
        }
        try {
            ObjectName on = this.getManagementStrategy().getManagementObjectNameStrategy().getObjectNameForCamelContext(this.camelContext);
            return this.getManagementStrategy().getManagementAgent().newProxyClient(on, ManagedCamelContextMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

