/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedCamelHealthMBean;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.ExceptionHelper;

public class ManagedCamelHealth
implements ManagedCamelHealthMBean {
    private final CamelContext context;
    private final HealthCheckRegistry healthCheckRegistry;

    public ManagedCamelHealth(CamelContext context, HealthCheckRegistry healthCheckRegistry) {
        this.context = context;
        this.healthCheckRegistry = healthCheckRegistry;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.context;
    }

    @Override
    public boolean isEnabled() {
        return this.healthCheckRegistry.isEnabled();
    }

    @Override
    public boolean isHealthy() {
        for (HealthCheck.Result result : HealthCheckHelper.invoke(this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isHealthyReadiness() {
        for (HealthCheck.Result result : HealthCheckHelper.invokeReadiness(this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isHealthyLiveness() {
        for (HealthCheck.Result result : HealthCheckHelper.invokeLiveness(this.context)) {
            if (result.getState() != HealthCheck.State.DOWN) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getHealthChecksIDs() {
        return this.healthCheckRegistry.getCheckIDs();
    }

    @Override
    public TabularData details() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.camelHealthDetailsTabularType());
            CompositeType type = CamelOpenMBeanTypes.camelHealthDetailsCompositeType();
            for (HealthCheck.Result result : HealthCheckHelper.invoke(this.context)) {
                String failureUri = (String)result.getDetails().getOrDefault("endpoint.uri", "");
                Integer failureCount = (Integer)result.getDetails().getOrDefault("failure.count", 0);
                String stacktrace = "";
                if (result.getError().isPresent()) {
                    stacktrace = ExceptionHelper.stackTraceToString(result.getError().get());
                }
                CompositeDataSupport data = new CompositeDataSupport(type, new String[]{"id", "group", "state", "enabled", "message", "failureUri", "failureCount", "failureStackTrace", "readiness", "liveness"}, new Object[]{result.getCheck().getId(), result.getCheck().getGroup(), result.getState().name(), result.getCheck().isEnabled(), result.getMessage().orElse(""), failureUri, failureCount, stacktrace, result.getCheck().isReadiness(), result.getCheck().isLiveness()});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    @Override
    public String invoke(String id) {
        Optional<HealthCheck.Result> result = HealthCheckHelper.invoke(this.context, id, Collections.emptyMap());
        return result.map(r -> r.getState().name()).orElse(HealthCheck.State.UNKNOWN.name());
    }

    @Override
    public void enableById(String id) {
        Optional<HealthCheck> hc = this.healthCheckRegistry.getCheck(id);
        if (hc.isPresent()) {
            hc.get().setEnabled(true);
        } else {
            Optional<HealthCheckRepository> hcr = this.healthCheckRegistry.getRepository(id);
            hcr.ifPresent(repository -> repository.setEnabled(true));
        }
    }

    @Override
    public void disableById(String id) {
        Optional<HealthCheck> hc = this.healthCheckRegistry.getCheck(id);
        if (hc.isPresent()) {
            hc.get().setEnabled(false);
        } else {
            Optional<HealthCheckRepository> hcr = this.healthCheckRegistry.getRepository(id);
            hcr.ifPresent(repository -> repository.setEnabled(false));
        }
    }
}

