/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedConsumerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.HostedService;

@ManagedResource(description="Managed Consumer")
public class ManagedConsumer
extends ManagedService
implements ManagedConsumerMBean {
    private final Consumer consumer;

    public ManagedConsumer(CamelContext context, Consumer consumer) {
        super(context, consumer);
        this.consumer = consumer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    @Override
    public String getEndpointUri() {
        return this.consumer.getEndpoint().getEndpointUri();
    }

    @Override
    public Integer getInflightExchanges() {
        if (this.getRouteId() != null) {
            return this.getContext().getInflightRepository().size(this.getRouteId());
        }
        return null;
    }

    @Override
    public boolean isHostedService() {
        Consumer consumer = this.consumer;
        if (consumer instanceof HostedService) {
            HostedService hs = (HostedService)((Object)consumer);
            return hs.isHostedService();
        }
        return false;
    }

    @Override
    public boolean isRemoteEndpoint() {
        return this.consumer.getEndpoint().isRemote();
    }
}

