/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedDoCatchMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CatchProcessor;

@ManagedResource(description="Managed DoCatch")
public class ManagedDoCatch
extends ManagedProcessor
implements ManagedDoCatchMBean {
    private final CatchProcessor processor;

    public ManagedDoCatch(CamelContext context, CatchProcessor processor, CatchDefinition definition) {
        super(context, processor, definition);
        this.processor = processor;
    }

    public CatchDefinition getDefinition() {
        return (CatchDefinition)super.getDefinition();
    }

    @Override
    public String getOnWhen() {
        WhenDefinition when = this.getDefinition().getOnWhen();
        if (when != null) {
            return when.getExpression().getExpression();
        }
        return null;
    }

    @Override
    public String getOnWhenLanguage() {
        WhenDefinition when = this.getDefinition().getOnWhen();
        if (when != null) {
            return when.getExpression().getLanguage();
        }
        return null;
    }

    @Override
    public Long getCaughtCount() {
        return this.processor.getCaughtCount();
    }

    @Override
    public Long getCaughtCount(String className) {
        return this.processor.getCaughtCount(className);
    }

    @Override
    public String[] getExceptionTypes() {
        return this.processor.getCaughtExceptionClassNames().toArray(new String[0]);
    }
}

