/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedExchangeFactoryManagerMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.URISupport;

@ManagedResource(description="Managed ExchangeFactory")
public class ManagedExchangeFactoryManager
extends ManagedService
implements ManagedExchangeFactoryManagerMBean {
    private final ExchangeFactoryManager exchangeFactoryManager;
    private boolean sanitize;

    public ManagedExchangeFactoryManager(CamelContext context, ExchangeFactoryManager exchangeFactoryManager) {
        super(context, exchangeFactoryManager);
        this.exchangeFactoryManager = exchangeFactoryManager;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.sanitize = strategy.getManagementAgent().getMask() != null ? strategy.getManagementAgent().getMask() : true;
    }

    @Override
    public Integer getConsumerCounter() {
        return this.exchangeFactoryManager.getConsumerCounter();
    }

    @Override
    public Integer getTotalPooled() {
        return this.exchangeFactoryManager.getPooledCounter();
    }

    @Override
    public Integer getCapacity() {
        return this.exchangeFactoryManager.getCapacity();
    }

    @Override
    public Boolean getStatisticsEnabled() {
        return this.exchangeFactoryManager.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(Boolean statisticsEnabled) {
        this.exchangeFactoryManager.setStatisticsEnabled(statisticsEnabled);
    }

    @Override
    public void resetStatistics() {
        this.exchangeFactoryManager.resetStatistics();
    }

    @Override
    public void purge() {
        this.exchangeFactoryManager.purge();
    }

    @Override
    public Long getTotalCreated() {
        return this.exchangeFactoryManager.getStatistics().getCreatedCounter();
    }

    @Override
    public Long getTotalAcquired() {
        return this.exchangeFactoryManager.getStatistics().getAcquiredCounter();
    }

    @Override
    public Long getTotalReleased() {
        return this.exchangeFactoryManager.getStatistics().getReleasedCounter();
    }

    @Override
    public Long getTotalDiscarded() {
        return this.exchangeFactoryManager.getStatistics().getDiscardedCounter();
    }

    @Override
    public TabularData listStatistics() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listExchangeFactoryTabularType());
            Collection<ExchangeFactory> factories = this.exchangeFactoryManager.getExchangeFactories();
            for (ExchangeFactory ef : factories) {
                CompositeType ct = CamelOpenMBeanTypes.listExchangeFactoryCompositeType();
                String routeId = ef.getRouteId();
                String url = ef.getConsumer().getEndpoint().getEndpointUri();
                if (this.sanitize) {
                    url = URISupport.sanitizeUri(url);
                }
                int capacity = ef.getCapacity();
                int size = ef.getSize();
                long created = 0L;
                long acquired = 0L;
                long released = 0L;
                long discarded = 0L;
                if (ef.isStatisticsEnabled()) {
                    created = ef.getStatistics().getCreatedCounter();
                    acquired = ef.getStatistics().getAcquiredCounter();
                    released = ef.getStatistics().getReleasedCounter();
                    discarded = ef.getStatistics().getDiscardedCounter();
                }
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"url", "routeId", "capacity", "pooled", "created", "acquired", "released", "discarded"}, new Object[]{url, routeId, capacity, size, created, acquired, released, discarded});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }
}

