/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.removr.spec;

import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.removr.spec.RemovrSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RemovrLeafSpec
extends RemovrSpec {
    public RemovrLeafSpec(String rawKey) {
        super(rawKey);
    }

    @Override
    public List<String> applyToMap(Map<String, Object> inputMap) {
        if (inputMap == null) {
            return null;
        }
        LinkedList<String> keysToBeRemoved = new LinkedList<String>();
        if (this.pathElement instanceof LiteralPathElement) {
            if (inputMap.containsKey(this.pathElement.getRawKey())) {
                keysToBeRemoved.add(this.pathElement.getRawKey());
            }
        } else if (this.pathElement instanceof StarPathElement) {
            StarPathElement star = (StarPathElement)this.pathElement;
            for (String key : inputMap.keySet()) {
                if (!star.stringMatch(key)) continue;
                keysToBeRemoved.add(key);
            }
        }
        return keysToBeRemoved;
    }

    @Override
    public List<Integer> applyToList(List<Object> inputList) {
        if (inputList == null) {
            return null;
        }
        if (this.pathElement instanceof LiteralPathElement) {
            Integer pathElementInt = this.getNonNegativeIntegerFromLiteralPathElement();
            if (pathElementInt != null && pathElementInt < inputList.size()) {
                return Collections.singletonList(pathElementInt);
            }
        } else if (this.pathElement instanceof StarAllPathElement) {
            ArrayList<Integer> toReturn = new ArrayList<Integer>(inputList.size());
            for (int index = 0; index < inputList.size(); ++index) {
                toReturn.add(index);
            }
            return toReturn;
        }
        return Collections.emptyList();
    }
}

