/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SkipLastByteInputStream
extends BufferedInputStream {
    private final byte matchLast;

    public SkipLastByteInputStream(InputStream delegate, byte matchLast) {
        super(delegate);
        this.matchLast = matchLast;
    }

    public SkipLastByteInputStream(InputStream delegate, int size2, byte matchLast) {
        super(delegate, size2);
        this.matchLast = matchLast;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c < 0) {
            return -1;
        }
        if (c == this.matchLast) {
            super.mark(1);
            int nextC = super.read();
            if (nextC < 0) {
                return -1;
            }
            super.reset();
        }
        return c;
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        byte lastByte;
        int count = super.read(buffer, off, len);
        if (count < 0) {
            return -1;
        }
        int lastIndex = off + count - 1;
        if (lastIndex >= 0 && (lastByte = buffer[lastIndex]) == this.matchLast) {
            super.mark(1);
            int nextC = super.read();
            if (nextC < 0) {
                return count - 1;
            }
            super.reset();
        }
        return count;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }
}

