/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jooq;

import org.apache.camel.CamelContext;
import org.apache.camel.component.jooq.JooqComponent;
import org.apache.camel.component.jooq.JooqConfiguration;
import org.apache.camel.component.jooq.JooqOperation;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.jooq.Configuration;

public class JooqComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private JooqConfiguration getOrCreateConfiguration(JooqComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new JooqConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JooqComponent target = (JooqComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(JooqComponentConfigurer.property(camelContext, JooqConfiguration.class, value));
                return true;
            }
            case "consumedelete": 
            case "consumeDelete": {
                this.getOrCreateConfiguration(target).setConsumeDelete(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "databaseconfiguration": 
            case "databaseConfiguration": {
                this.getOrCreateConfiguration(target).setDatabaseConfiguration(JooqComponentConfigurer.property(camelContext, Configuration.class, value));
                return true;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                target.setHealthCheckConsumerEnabled(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                target.setHealthCheckProducerEnabled(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JooqComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(JooqComponentConfigurer.property(camelContext, JooqOperation.class, value));
                return true;
            }
            case "query": {
                this.getOrCreateConfiguration(target).setQuery(JooqComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return JooqConfiguration.class;
            }
            case "consumedelete": 
            case "consumeDelete": {
                return Boolean.TYPE;
            }
            case "databaseconfiguration": 
            case "databaseConfiguration": {
                return Configuration.class;
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return Boolean.TYPE;
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return JooqOperation.class;
            }
            case "query": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JooqComponent target = (JooqComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "consumedelete": 
            case "consumeDelete": {
                return this.getOrCreateConfiguration(target).isConsumeDelete();
            }
            case "databaseconfiguration": 
            case "databaseConfiguration": {
                return this.getOrCreateConfiguration(target).getDatabaseConfiguration();
            }
            case "healthcheckconsumerenabled": 
            case "healthCheckConsumerEnabled": {
                return target.isHealthCheckConsumerEnabled();
            }
            case "healthcheckproducerenabled": 
            case "healthCheckProducerEnabled": {
                return target.isHealthCheckProducerEnabled();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "query": {
                return this.getOrCreateConfiguration(target).getQuery();
            }
        }
        return null;
    }
}

