/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.GeneratorStatementType;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectSelectStep;
import org.jooq.Table;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AbstractStoreQuery;
import org.jooq.impl.DSL;
import org.jooq.impl.Default;
import org.jooq.impl.Keywords;
import org.jooq.impl.LazyVal;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartCollectionView;
import org.jooq.impl.ScalarSubquery;
import org.jooq.impl.Tools;
import org.jooq.impl.Val;

final class FieldMapsForInsert
extends AbstractQueryPart
implements QOM.UNotYetImplemented {
    static final Set<SQLDialect> CASTS_NEEDED = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> CASTS_NEEDED_FOR_MERGE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_DEFAULT_EXPRESSION = SQLDialect.supportedBy(SQLDialect.SQLITE);
    final Table<?> table;
    final Map<Field<?>, Field<?>> empty;
    final Map<Field<?>, List<Field<?>>> values;
    int rows;
    int nextRow = -1;

    FieldMapsForInsert(Table<?> table) {
        this.table = table;
        this.values = new LinkedHashMap();
        this.empty = new LinkedHashMap();
    }

    void clear() {
        this.empty.clear();
        this.values.clear();
        this.rows = 0;
        this.nextRow = -1;
    }

    final void from(FieldMapsForInsert i) {
        this.empty.putAll(i.empty);
        for (Map.Entry<Field<?>, List<Field<?>>> e : i.values.entrySet()) {
            this.values.put(e.getKey(), new ArrayList(e.getValue()));
        }
        this.rows = i.rows;
        this.nextRow = i.nextRow;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (!this.isExecutable()) {
            ctx.formatSeparator().start(Clause.INSERT_VALUES).visit(Keywords.K_DEFAULT_VALUES).end(Clause.INSERT_VALUES);
        } else if (this.rows == 1 && this.supportsValues(ctx)) {
            this.toSQLValues(ctx);
        } else {
            switch (ctx.family()) {
                case TRINO: 
                case MARIADB: {
                    if (this.supportsValues(ctx)) {
                        this.toSQLValues(ctx);
                        break;
                    }
                    FieldMapsForInsert.toSQLInsertSelect(ctx, this.insertSelect(ctx, GeneratorStatementType.INSERT));
                    break;
                }
                case FIREBIRD: {
                    FieldMapsForInsert.toSQLInsertSelect(ctx, this.insertSelect(ctx, GeneratorStatementType.INSERT));
                    break;
                }
                default: {
                    this.toSQLValues(ctx);
                }
            }
        }
    }

    private final void toSQLValues(Context<?> ctx) {
        ctx.formatSeparator().start(Clause.INSERT_VALUES).visit(Keywords.K_VALUES).sql(' ');
        this.toSQL92Values(ctx);
        ctx.end(Clause.INSERT_VALUES);
    }

    static final void toSQLInsertSelect(Context<?> ctx, Select<?> select) {
        ctx.formatSeparator().start(Clause.INSERT_SELECT).visit(FieldMapsForInsert.patchSelectWithUnions(ctx, select)).end(Clause.INSERT_SELECT);
    }

    private static final Select<?> patchSelectWithUnions(Context<?> ctx, Select<?> select) {
        switch (ctx.family()) {
            default: 
        }
        return select;
    }

    private final boolean supportsValues(Context<?> ctx) {
        switch (ctx.family()) {
            case TRINO: {
                for (List<Field<?>> row : this.values.values()) {
                    for (Field<?> value : row) {
                        if (!(value instanceof ScalarSubquery)) continue;
                        return false;
                    }
                }
                return true;
            }
            case MARIADB: {
                for (List<Field<?>> row : this.values.values()) {
                    for (Field<?> value : row) {
                        if (!(value instanceof ScalarSubquery)) continue;
                        ScalarSubquery s = (ScalarSubquery)value;
                        if (!Tools.containsTable(s.query.$from(), this.table, false)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    final Select<Record> insertSelect(Context<?> ctx, GeneratorStatementType statementType) {
        Select<Record> select = null;
        Map<Field<?>, List<Field<?>>> v = this.valuesFlattened(ctx, statementType);
        boolean needsCast = CASTS_NEEDED_FOR_MERGE.contains((Object)ctx.dialect()) && ctx.data(Tools.ExtendedDataKey.DATA_INSERT_ON_DUPLICATE_KEY_UPDATE) != null;
        for (int i = 0; i < this.rows; ++i) {
            int row = i;
            SelectSelectStep<Record> iteration = DSL.select(Tools.map(v.entrySet(), e -> FieldMapsForInsert.patchDefault0(this.castNullsIfNeeded(ctx, needsCast, (Field)((List)e.getValue()).get(row)), (Field)e.getKey())));
            select = select == null ? iteration : select.unionAll(iteration);
        }
        return select;
    }

    final Field<?> castNullsIfNeeded(Context<?> ctx, boolean needsCast, Field<?> f) {
        Val val;
        if (needsCast && f instanceof Val && (val = (Val)f).isInline(ctx) && val.getValue() == null) {
            return f.cast(f.getDataType());
        }
        return f;
    }

    final void toSQL92Values(Context<?> ctx) {
        boolean indent = this.values.size() > 1;
        RenderContext.CastMode previous = ctx.castMode();
        if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
            ctx.castMode(RenderContext.CastMode.NEVER);
        }
        for (int row = 0; row < this.rows; ++row) {
            if (row > 0) {
                ctx.sql(", ");
            }
            ctx.start(Clause.FIELD_ROW).sql('(');
            if (indent) {
                ctx.formatIndentStart();
            }
            String separator = "";
            for (Map.Entry<Field<?>, List<Field<?>>> e : this.valuesFlattened(ctx, GeneratorStatementType.INSERT).entrySet()) {
                List<Field<?>> list = e.getValue();
                ctx.sql(separator);
                if (indent) {
                    ctx.formatNewLine();
                }
                ctx.visit(FieldMapsForInsert.patchDefault(ctx, list.get(row), e.getKey()));
                separator = ", ";
            }
            if (indent) {
                ctx.formatIndentEnd().formatNewLine();
            }
            ctx.sql(')').end(Clause.FIELD_ROW);
        }
        if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
            ctx.castMode(previous);
        }
    }

    static final Field<?> patchDefault(Context<?> ctx, Field<?> d, Field<?> f) {
        if (NO_SUPPORT_DEFAULT_EXPRESSION.contains((Object)ctx.dialect())) {
            return FieldMapsForInsert.patchDefault0(d, f);
        }
        return d;
    }

    static final Field<?> patchDefault0(Field<?> d, Field<?> f) {
        if (d instanceof Default) {
            return Tools.orElse(f.getDataType().default_(), () -> DSL.inline(null, f));
        }
        return d;
    }

    final void addFields(Collection<?> fields) {
        if (this.rows == 0) {
            this.newRecord();
        }
        this.initNextRow();
        for (Object field : fields) {
            Field<?> f = Tools.tableField(this.table, field);
            Field e = this.empty.computeIfAbsent(f, LazyVal::new);
            if (this.values.containsKey(f)) continue;
            this.values.put(f, this.rows > 0 ? new ArrayList<Field>(Collections.nCopies(this.rows, e)) : new ArrayList());
        }
    }

    final void set(Collection<? extends Field<?>> fields) {
        this.initNextRow();
        Iterator<Field<?>> it1 = fields.iterator();
        Iterator<List<Field<?>>> it2 = this.values.values().iterator();
        while (it1.hasNext() && it2.hasNext()) {
            it2.next().set(this.rows - 1, it1.next());
        }
        if (it1.hasNext() || it2.hasNext()) {
            throw new IllegalArgumentException("Added record size (" + fields.size() + ") must match fields size (" + this.values.size() + ")");
        }
    }

    final <T> Field<T> set(Field<T> field, Field<T> value) {
        this.addFields(Collections.singletonList(field));
        return this.values.get(field).set(this.rows - 1, value);
    }

    final void set(Map<?, ?> map) {
        this.addFields(map.keySet());
        map.forEach((k, v) -> {
            Field<?> field = Tools.tableField(this.table, k);
            this.values.get(field).set(this.rows - 1, Tools.field(v, field));
        });
    }

    private final void initNextRow() {
        if (this.rows == this.nextRow) {
            Iterator<List<Field<?>>> v = this.values.values().iterator();
            Iterator<Field<?>> e = this.empty.values().iterator();
            while (v.hasNext() && e.hasNext()) {
                v.next().add(e.next());
            }
            ++this.rows;
        }
    }

    final void newRecord() {
        if (this.nextRow < this.rows) {
            ++this.nextRow;
        }
    }

    final List<Row> rows() {
        final List<Map<Field<?>, Field<?>>> maps = this.maps();
        return new AbstractList<Row>(){

            @Override
            public Row get(int index) {
                return Tools.row0(((Map)maps.get(index)).values().toArray(Tools.EMPTY_FIELD));
            }

            @Override
            public int size() {
                return FieldMapsForInsert.this.rows;
            }
        };
    }

    final List<Map<Field<?>, Field<?>>> maps() {
        return new AbstractList<Map<Field<?>, Field<?>>>(){

            @Override
            public Map<Field<?>, Field<?>> get(int index) {
                return FieldMapsForInsert.this.map(index);
            }

            @Override
            public int size() {
                return FieldMapsForInsert.this.rows;
            }
        };
    }

    final Map<Field<?>, Field<?>> map(final int index) {
        return new AbstractMap<Field<?>, Field<?>>(){
            transient Set<Map.Entry<Field<?>, Field<?>>> entrySet;

            @Override
            public Set<Map.Entry<Field<?>, Field<?>>> entrySet() {
                if (this.entrySet == null) {
                    this.entrySet = new EntrySet();
                }
                return this.entrySet;
            }

            @Override
            public boolean containsKey(Object key) {
                return FieldMapsForInsert.this.values.containsKey(key);
            }

            @Override
            public boolean containsValue(Object value) {
                return Tools.anyMatch(FieldMapsForInsert.this.values.values(), list -> ((Field)list.get(index)).equals(value));
            }

            @Override
            public Field<?> get(Object key) {
                List<Field<?>> list = FieldMapsForInsert.this.values.get(key);
                return list == null ? null : list.get(index);
            }

            @Override
            public Field<?> put(Field<?> key, Field<?> value) {
                return FieldMapsForInsert.this.set(key, value);
            }

            @Override
            public Field<?> remove(Object key) {
                List<Field<?>> list = FieldMapsForInsert.this.values.get(key);
                FieldMapsForInsert.this.values.remove(key);
                return list == null ? null : list.get(index);
            }

            @Override
            public Set<Field<?>> keySet() {
                return FieldMapsForInsert.this.values.keySet();
            }

            final class EntrySet
            extends AbstractSet<Map.Entry<Field<?>, Field<?>>> {
                EntrySet() {
                }

                @Override
                public final int size() {
                    return FieldMapsForInsert.this.values.size();
                }

                @Override
                public final void clear() {
                    FieldMapsForInsert.this.values.clear();
                }

                @Override
                public final Iterator<Map.Entry<Field<?>, Field<?>>> iterator() {
                    return new Iterator<Map.Entry<Field<?>, Field<?>>>(){
                        final Iterator<Map.Entry<Field<?>, List<Field<?>>>> delegate;
                        {
                            this.delegate = FieldMapsForInsert.this.values.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        @Override
                        public Map.Entry<Field<?>, Field<?>> next() {
                            Map.Entry<Field<?>, List<Field<?>>> entry = this.delegate.next();
                            return new AbstractMap.SimpleImmutableEntry(entry.getKey(), entry.getValue().get(index));
                        }

                        @Override
                        public void remove() {
                            this.delegate.remove();
                        }
                    };
                }
            }
        };
    }

    final Map<Field<?>, Field<?>> lastMap() {
        return this.map(this.rows - 1);
    }

    final boolean isExecutable() {
        return this.rows > 0;
    }

    final Set<Field<?>> toSQLReferenceKeys(Context<?> ctx) {
        block4: {
            if (!this.isExecutable()) {
                return Collections.emptySet();
            }
            if (this.values.isEmpty()) {
                return Collections.emptySet();
            }
            for (Field<?> field : this.values.keySet()) {
                if (field instanceof AbstractStoreQuery.UnknownField) continue;
                break block4;
            }
            return Collections.emptySet();
        }
        Set<Field<?>> fields = this.keysFlattened(ctx, GeneratorStatementType.INSERT);
        if (!fields.isEmpty()) {
            ctx.data(Tools.BooleanDataKey.DATA_STORE_ASSIGNMENT, true, c -> c.sql(" (").visit(QueryPartCollectionView.wrap(fields).qualify(false)).sql(')'));
        }
        return fields;
    }

    private static final <E> Iterable<E> removeReadonly(Context<?> ctx, Iterable<E> it, Function<? super E, ? extends Field<?>> f) {
        return it;
    }

    final Set<Field<?>> keysFlattened(Context<?> ctx, GeneratorStatementType statementType) {
        return this.valuesFlattened(ctx, statementType).keySet();
    }

    final Map<Field<?>, List<Field<?>>> valuesFlattened(Context<?> ctx, GeneratorStatementType statementType) {
        LinkedHashMap result = new LinkedHashMap();
        Object overlapping = null;
        for (Map.Entry entry : FieldMapsForInsert.removeReadonly(ctx, this.values.entrySet(), Map.Entry::getKey)) {
            Field key = (Field)entry.getKey();
            DataType keyType = key.getDataType();
            List value = (List)entry.getValue();
            if (keyType.isEmbeddable()) {
                ArrayList<Iterator<Field>> valueFlattened = new ArrayList<Iterator<Field>>(value.size());
                for (Field v : value) {
                    valueFlattened.add(Tools.flatten(v).iterator());
                }
                for (Field k : Tools.flatten(key)) {
                    ArrayList<Field> list = new ArrayList<Field>(value.size());
                    for (Iterator iterator : valueFlattened) {
                        list.add(iterator.hasNext() ? (Field)iterator.next() : null);
                    }
                    result.put(k, list);
                }
                continue;
            }
            result.put(key, value);
        }
        return result;
    }
}

