/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.language.joor.JoorCompiler;
import org.apache.camel.language.joor.JoorMethod;
import org.apache.camel.support.ExpressionAdapter;

public class JoorExpression
extends ExpressionAdapter {
    private final String text;
    private JoorCompiler compiler;
    private JoorMethod method;
    private Class<?> resultType;
    private boolean preCompile = true;
    private boolean singleQuotes = true;

    public JoorExpression(String text) {
        this.text = text;
    }

    public String toString() {
        return "joor:" + this.text;
    }

    public JoorCompiler getCompiler() {
        return this.compiler;
    }

    public void setCompiler(JoorCompiler compiler) {
        this.compiler = compiler;
    }

    public boolean isPreCompile() {
        return this.preCompile;
    }

    public void setPreCompile(boolean preCompile) {
        this.preCompile = preCompile;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSingleQuotes() {
        return this.singleQuotes;
    }

    public void setSingleQuotes(boolean singleQuotes) {
        this.singleQuotes = singleQuotes;
    }

    @Override
    public Object evaluate(Exchange exchange) {
        Object out;
        Object body;
        JoorMethod target = this.method;
        if (target == null) {
            target = this.compiler.compile(exchange.getContext(), this.text, this.singleQuotes);
        }
        Optional<Object> optional = (body = exchange.getIn().getBody()) instanceof Optional ? (Optional<Object>)body : Optional.ofNullable(body);
        try {
            out = target.evaluate(exchange.getContext(), exchange, exchange.getIn(), body, optional);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this, exchange, e);
        }
        if (out != null && this.resultType != null) {
            return exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, out);
        }
        return out;
    }

    @Override
    public void init(CamelContext context) {
        super.init(context);
        if (this.preCompile && this.method == null) {
            this.method = this.compiler.compile(context, this.text, this.singleQuotes);
        }
    }
}

