/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.joor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.camel.language.joor.ByteArrayClassLoader;
import org.apache.camel.language.joor.CompilationUnit;
import org.apache.camel.util.FileUtil;
import org.joor.ReflectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiCompile {
    private static final Logger LOG = LoggerFactory.getLogger(MultiCompile.class);

    private MultiCompile() {
    }

    public static CompilationUnit.Result compileUnit(CompilationUnit unit) {
        return MultiCompile.compileUnit(unit, new ArrayList<String>());
    }

    public static CompilationUnit.Result compileUnit(CompilationUnit unit, List<String> options) {
        CompilationUnit.Result result = CompilationUnit.result();
        ArrayList files = new ArrayList();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ClassLoader cl = unit.getClassLoader() != null ? unit.getClassLoader() : lookup.lookupClass().getClassLoader();
        unit.getInput().forEach((cn, code) -> {
            try {
                Class<?> clazz = cl.loadClass((String)cn);
                result.addResult((String)cn, clazz, null);
                LOG.debug("Class already compiled: {}", cn);
            }
            catch (ClassNotFoundException ignore) {
                LOG.debug("Class must be compiled: {}", cn);
                files.add(new CharSequenceJavaFileObject((String)cn, (CharSequence)code));
            }
        });
        if (files.isEmpty()) {
            return result;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        try {
            if (!options.contains("-classpath")) {
                StringBuilder classpath = new StringBuilder();
                String separator = System.getProperty("path.separator");
                String cp = System.getProperty("java.class.path");
                String mp = System.getProperty("jdk.module.path");
                if (cp != null && !cp.isEmpty()) {
                    classpath.append(cp);
                }
                if (mp != null && !mp.isEmpty()) {
                    classpath.append(mp);
                }
                if (cl instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)cl).getURLs()) {
                        if (!classpath.isEmpty()) {
                            classpath.append(separator);
                        }
                        if (!"file".equals(url.getProtocol())) continue;
                        classpath.append(new File(url.toURI()));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Java jOOR Compile -classpath: {}", (Object)classpath);
                }
                options.addAll(Arrays.asList("-classpath", classpath.toString()));
            }
            DiagnosticCollector dc = new DiagnosticCollector();
            ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
            StringWriter out = new StringWriter();
            JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, dc, options, null, files);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Compiling files: {}", files);
            }
            boolean success = task.call();
            LOG.debug("Compiled success: {}", (Object)success);
            MultiCompile.cleanupWaste();
            if (!success || fileManager.isEmpty()) {
                if (dc.getDiagnostics().isEmpty()) {
                    throw new ReflectException("Compilation error:\n" + String.valueOf(out));
                }
                StringJoiner sj = new StringJoiner("\n");
                dc.getDiagnostics().stream().filter(d -> Diagnostic.Kind.ERROR.equals((Object)d.getKind())).forEach(d -> sj.add(d.toString()));
                throw new ReflectException("Compilation error:\n" + String.valueOf(sj) + "\n" + String.valueOf(out));
            }
            int index = 2;
            ByteArrayClassLoader c = new ByteArrayClassLoader(fileManager.classes());
            for (CharSequenceJavaFileObject f : files) {
                Class<?> caller;
                String className = f.getClassName();
                if ((caller = MultiCompile.findCompiledClassViaIndex(index++)) != null && className.startsWith(caller.getPackageName() + ".") && Character.isUpperCase(className.charAt(caller.getPackageName().length() + 1))) {
                    HashMap<String, byte[]> byteCodes;
                    MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(caller, lookup);
                    Class<?> clazz = fileManager.loadAndReturnMainClass(className, (arg_0, arg_1) -> MultiCompile.lambda$compileUnit$3(privateLookup, byteCodes = new HashMap<String, byte[]>(), arg_0, arg_1));
                    if (clazz != null) {
                        result.addResult(className, clazz, (byte[])byteCodes.get(className));
                    }
                    byteCodes.forEach((cn, bc) -> result.addResult((String)cn, null, (byte[])bc));
                    continue;
                }
                HashMap<String, byte[]> byteCodes = new HashMap<String, byte[]>();
                Class<?> clazz = fileManager.loadAndReturnMainClass(className, (name, bytes) -> {
                    Class<?> loaded = c.loadClass((String)name);
                    if (loaded != null) {
                        byteCodes.put((String)name, (byte[])bytes);
                    }
                    return loaded;
                });
                if (clazz != null) {
                    result.addResult(className, clazz, (byte[])byteCodes.get(className));
                }
                byteCodes.forEach((cn, bc) -> result.addResult((String)cn, null, (byte[])bc));
            }
            return result;
        }
        catch (ReflectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectException("Error while compiling unit " + String.valueOf(unit), e);
        }
    }

    private static Class<?> findCompiledClassViaIndex(int index) {
        StackWalker.StackFrame sf = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.skip(index).findFirst().orElse(null));
        return sf != null ? sf.getDeclaringClass() : null;
    }

    private static void cleanupWaste() {
        FileUtil.deleteFile(new File("jakarta.inject.Named"));
    }

    private static /* synthetic */ Class lambda$compileUnit$3(MethodHandles.Lookup privateLookup, Map byteCodes, String name, byte[] bytes) throws Exception {
        Class<?> loaded = privateLookup.defineClass(bytes);
        if (loaded != null) {
            byteCodes.put(name, bytes);
        }
        return loaded;
    }

    static final class ClassFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final Map<String, JavaFileObject> fileObjectMap = new LinkedHashMap<String, JavaFileObject>();
        private Map<String, byte[]> classes;

        ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) {
            JavaFileObject result = new JavaFileObject(className, kind);
            this.fileObjectMap.put(className, result);
            return result;
        }

        boolean isEmpty() {
            return this.fileObjectMap.isEmpty();
        }

        Map<String, byte[]> classes() {
            if (this.classes == null) {
                this.classes = new LinkedHashMap<String, byte[]>();
                for (Map.Entry<String, JavaFileObject> entry : this.fileObjectMap.entrySet()) {
                    this.classes.put(entry.getKey(), entry.getValue().getBytes());
                }
            }
            return this.classes;
        }

        Class<?> loadAndReturnMainClass(String mainClassName, ThrowingBiFunction<String, byte[], Class<?>> definer) throws Exception {
            Class<?> result = null;
            ArrayDeque<Map.Entry<String, byte[]>> queue = new ArrayDeque<Map.Entry<String, byte[]>>(this.classes().entrySet());
            int n1 = queue.size();
            for (int i1 = 0; i1 < n1 && !queue.isEmpty(); ++i1) {
                int n2 = queue.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Map.Entry entry = (Map.Entry)queue.pop();
                    try {
                        Class<?> c = definer.apply((String)entry.getKey(), (byte[])entry.getValue());
                        if (!mainClassName.equals(entry.getKey())) continue;
                        result = c;
                        continue;
                    }
                    catch (ReflectException e) {
                        queue.offer(entry);
                    }
                }
            }
            return result;
        }
    }

    static final class CharSequenceJavaFileObject
    extends SimpleJavaFileObject {
        final CharSequence content;
        final String className;

        public CharSequenceJavaFileObject(String className, CharSequence content) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.className = className;
            this.content = content;
        }

        public String getClassName() {
            return this.className;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.content;
        }

        @Override
        public String toString() {
            return this.className;
        }
    }

    @FunctionalInterface
    static interface ThrowingBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Exception;
    }

    static final class JavaFileObject
    extends SimpleJavaFileObject {
        final ByteArrayOutputStream os = new ByteArrayOutputStream();

        JavaFileObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        byte[] getBytes() {
            return this.os.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.os;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.os.toString(StandardCharsets.UTF_8);
        }
    }
}

