/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManagerFactory;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultTransactionStrategy
implements TransactionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTransactionStrategy.class);
    private TransactionTemplate transactionTemplate;
    private PlatformTransactionManager transactionManager;

    public DefaultTransactionStrategy(CamelContext camelContext, EntityManagerFactory entityManagerFactory) {
        this.initTransactionManager(camelContext);
        if (this.transactionManager == null && entityManagerFactory != null) {
            this.transactionManager = this.createTransactionManager(entityManagerFactory);
        }
        this.transactionTemplate = this.createTransactionTemplate();
    }

    @Override
    public void executeInTransaction(Runnable runnable) {
        this.transactionTemplate.execute(status -> {
            runnable.run();
            return null;
        });
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.transactionTemplate = this.createTransactionTemplate();
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    private void initTransactionManager(CamelContext camelContext) {
        Map<String, Object> map;
        if (this.transactionManager == null && camelContext != null) {
            map = camelContext.getRegistry().findByTypeWithName(PlatformTransactionManager.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.transactionManager = map.values().iterator().next();
                    LOG.info("Using TransactionManager found in registry with id [{}] {}", (Object)map.keySet().iterator().next(), (Object)this.transactionManager);
                } else {
                    LOG.debug("Could not find a single TransactionManager in registry as there was {} instances.", (Object)map.size());
                }
            }
        } else {
            LOG.info("Using TransactionManager configured on this component: {}", (Object)this.transactionManager);
        }
        if (this.transactionManager == null && camelContext != null && (map = camelContext.getRegistry().findByTypeWithName(TransactionTemplate.class)) != null) {
            if (map.size() == 1) {
                this.transactionManager = ((TransactionTemplate)map.values().iterator().next()).getTransactionManager();
                LOG.info("Using TransactionManager found in registry with id [{}] {}", (Object)map.keySet().iterator().next(), (Object)this.transactionManager);
            } else {
                LOG.debug("Could not find a single TransactionTemplate in registry as there was {} instances.", (Object)map.size());
            }
        }
    }

    protected PlatformTransactionManager createTransactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager tm = new JpaTransactionManager(entityManagerFactory);
        tm.afterPropertiesSet();
        return tm;
    }

    protected TransactionTemplate createTransactionTemplate() {
        TransactionTemplate newTransactionTemplate = new TransactionTemplate(this.getTransactionManager());
        newTransactionTemplate.setPropagationBehavior(0);
        newTransactionTemplate.afterPropertiesSet();
        return newTransactionTemplate;
    }
}

