/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.persistenceunit;

import java.net.URL;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.persistenceunit.SimplePersistenceManagedTypes;
import org.springframework.util.Assert;

public interface PersistenceManagedTypes {
    public List<String> getManagedClassNames();

    public List<String> getManagedPackages();

    @Nullable
    public URL getPersistenceUnitRootUrl();

    public static PersistenceManagedTypes of(String ... managedClassNames) {
        Assert.notNull((Object)managedClassNames, "'managedClassNames' must not be null");
        return new SimplePersistenceManagedTypes(List.of(managedClassNames), List.of());
    }

    public static PersistenceManagedTypes of(List<String> managedClassNames, List<String> managedPackages) {
        return new SimplePersistenceManagedTypes(managedClassNames, managedPackages);
    }
}

