/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.PersistenceUnit;
import jakarta.persistence.SynchronizationType;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.jndi.JndiLocatorDelegate;
import org.springframework.jndi.JndiTemplate;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.orm.jpa.support.InjectionCodeGenerator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PersistenceAnnotationBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
BeanRegistrationAotProcessor,
PriorityOrdered,
BeanFactoryAware,
Serializable {
    @Nullable
    private Object jndiEnvironment;
    private boolean resourceRef = true;
    @Nullable
    private transient Map<String, String> persistenceUnits;
    @Nullable
    private transient Map<String, String> persistenceContexts;
    @Nullable
    private transient Map<String, String> extendedPersistenceContexts;
    private transient String defaultPersistenceUnitName = "";
    private int order = 0x7FFFFFFB;
    @Nullable
    private transient ListableBeanFactory beanFactory;
    private final transient Map<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(256);
    private final Map<Object, EntityManager> extendedEntityManagersToClose = new ConcurrentHashMap<Object, EntityManager>(16);

    public void setJndiTemplate(Object jndiTemplate) {
        this.jndiEnvironment = jndiTemplate;
    }

    public void setJndiEnvironment(Properties jndiEnvironment) {
        this.jndiEnvironment = jndiEnvironment;
    }

    public void setResourceRef(boolean resourceRef) {
        this.resourceRef = resourceRef;
    }

    public void setPersistenceUnits(Map<String, String> persistenceUnits) {
        this.persistenceUnits = persistenceUnits;
    }

    public void setPersistenceContexts(Map<String, String> persistenceContexts) {
        this.persistenceContexts = persistenceContexts;
    }

    public void setExtendedPersistenceContexts(Map<String, String> extendedPersistenceContexts) {
        this.extendedPersistenceContexts = extendedPersistenceContexts;
    }

    public void setDefaultPersistenceUnitName(@Nullable String unitName) {
        this.defaultPersistenceUnitName = unitName != null ? unitName : "";
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory lbf;
            this.beanFactory = lbf = (ListableBeanFactory)beanFactory;
        }
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        this.findInjectionMetadata(beanDefinition, beanType, beanName);
    }

    @Override
    public void resetBeanDefinition(String beanName) {
        this.injectionMetadataCache.remove(beanName);
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        String beanName = registeredBean.getBeanName();
        RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
        InjectionMetadata metadata = this.findInjectionMetadata(beanDefinition, beanClass, beanName);
        Collection<InjectionMetadata.InjectedElement> injectedElements = metadata.getInjectedElements(beanDefinition.getPropertyValues());
        if (!CollectionUtils.isEmpty(injectedElements)) {
            return new AotContribution(beanClass, injectedElements);
        }
        return null;
    }

    private InjectionMetadata findInjectionMetadata(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        InjectionMetadata metadata = this.findPersistenceMetadata(beanName, beanType, null);
        metadata.checkConfigMembers(beanDefinition);
        return metadata;
    }

    @Override
    public PropertyValues postProcessProperties(PropertyValues pvs, Object bean2, String beanName) {
        InjectionMetadata metadata = this.findPersistenceMetadata(beanName, bean2.getClass(), pvs);
        try {
            metadata.inject(bean2, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of persistence dependencies failed", ex);
        }
        return pvs;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean2, String beanName) {
        EntityManager emToClose = this.extendedEntityManagersToClose.remove(bean2);
        EntityManagerFactoryUtils.closeEntityManager(emToClose);
    }

    @Override
    public boolean requiresDestruction(Object bean2) {
        return this.extendedEntityManagersToClose.containsKey(bean2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findPersistenceMetadata(String beanName, Class<?> clazz, @Nullable PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength(beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = this.injectionMetadataCache.get(cacheKey);
        if (InjectionMetadata.needsRefresh(metadata, clazz)) {
            Map<String, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(cacheKey);
                if (InjectionMetadata.needsRefresh(metadata, clazz)) {
                    if (metadata != null) {
                        metadata.clear(pvs);
                    }
                    metadata = this.buildPersistenceMetadata(clazz);
                    this.injectionMetadataCache.put(cacheKey, metadata);
                }
            }
        }
        return metadata;
    }

    private InjectionMetadata buildPersistenceMetadata(Class<?> clazz) {
        if (!AnnotationUtils.isCandidateClass(clazz, Arrays.asList(PersistenceContext.class, PersistenceUnit.class))) {
            return InjectionMetadata.EMPTY;
        }
        ArrayList<InjectionMetadata.InjectedElement> elements = new ArrayList<InjectionMetadata.InjectedElement>();
        Class<?> targetClass = clazz;
        do {
            ArrayList currElements = new ArrayList();
            ReflectionUtils.doWithLocalFields(targetClass, field -> {
                if (field.isAnnotationPresent(PersistenceContext.class) || field.isAnnotationPresent(PersistenceUnit.class)) {
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("Persistence annotations are not supported on static fields");
                    }
                    currElements.add(new PersistenceElement(field, field, null));
                }
            });
            ReflectionUtils.doWithLocalMethods(targetClass, method -> {
                Method bridgedMethod = BridgeMethodResolver.findBridgedMethod(method);
                if (!BridgeMethodResolver.isVisibilityBridgeMethodPair(method, bridgedMethod)) {
                    return;
                }
                if ((bridgedMethod.isAnnotationPresent(PersistenceContext.class) || bridgedMethod.isAnnotationPresent(PersistenceUnit.class)) && method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Persistence annotations are not supported on static methods");
                    }
                    if (method.getParameterCount() != 1) {
                        throw new IllegalStateException("Persistence annotation requires a single-arg method: " + String.valueOf(method));
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod(bridgedMethod, clazz);
                    currElements.add(new PersistenceElement(method, bridgedMethod, pd));
                }
            });
            elements.addAll(0, currElements);
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return InjectionMetadata.forElements(elements, clazz);
    }

    @Nullable
    protected EntityManagerFactory getPersistenceUnit(@Nullable String unitName) {
        if (this.persistenceUnits != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if (unitNameForLookup.isEmpty()) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = this.persistenceUnits.get(unitNameForLookup)) == null && unitNameForLookup.isEmpty() && this.persistenceUnits.size() == 1) {
                jndiName = this.persistenceUnits.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return this.lookup(jndiName, EntityManagerFactory.class);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain EntityManagerFactory [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    @Nullable
    protected EntityManager getPersistenceContext(@Nullable String unitName, boolean extended) {
        Map<String, String> contexts;
        Map<String, String> map = contexts = extended ? this.extendedPersistenceContexts : this.persistenceContexts;
        if (contexts != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if (unitNameForLookup.isEmpty()) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = contexts.get(unitNameForLookup)) == null && unitNameForLookup.isEmpty() && contexts.size() == 1) {
                jndiName = contexts.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return this.lookup(jndiName, EntityManager.class);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Could not obtain EntityManager [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    protected EntityManagerFactory findEntityManagerFactory(@Nullable String unitName, @Nullable String requestingBeanName) throws NoSuchBeanDefinitionException {
        String unitNameForLookup;
        String string = unitNameForLookup = unitName != null ? unitName : "";
        if (unitNameForLookup.isEmpty()) {
            unitNameForLookup = this.defaultPersistenceUnitName;
        }
        if (!unitNameForLookup.isEmpty()) {
            return this.findNamedEntityManagerFactory(unitNameForLookup, requestingBeanName);
        }
        return this.findDefaultEntityManagerFactory(requestingBeanName);
    }

    protected EntityManagerFactory findNamedEntityManagerFactory(String unitName, @Nullable String requestingBeanName) throws NoSuchBeanDefinitionException {
        ListableBeanFactory listableBeanFactory;
        Assert.state(this.beanFactory != null, "ListableBeanFactory required for EntityManagerFactory bean lookup");
        EntityManagerFactory emf = EntityManagerFactoryUtils.findEntityManagerFactory(this.beanFactory, unitName);
        if (requestingBeanName != null && (listableBeanFactory = this.beanFactory) instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)((Object)listableBeanFactory);
            cbf.registerDependentBean(unitName, requestingBeanName);
        }
        return emf;
    }

    protected EntityManagerFactory findDefaultEntityManagerFactory(@Nullable String requestingBeanName) throws NoSuchBeanDefinitionException {
        Assert.state(this.beanFactory != null, "ListableBeanFactory required for EntityManagerFactory bean lookup");
        ListableBeanFactory listableBeanFactory = this.beanFactory;
        if (listableBeanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)listableBeanFactory;
            NamedBeanHolder<EntityManagerFactory> emfHolder = clbf.resolveNamedBean(EntityManagerFactory.class);
            if (requestingBeanName != null) {
                clbf.registerDependentBean(emfHolder.getBeanName(), requestingBeanName);
            }
            return emfHolder.getBeanInstance();
        }
        return this.beanFactory.getBean(EntityManagerFactory.class);
    }

    protected <T> T lookup(String jndiName, Class<T> requiredType) throws Exception {
        return new LocatorDelegate().lookup(jndiName, requiredType);
    }

    private static class AotContribution
    implements BeanRegistrationAotContribution {
        private static final String REGISTERED_BEAN_PARAMETER = "registeredBean";
        private static final String INSTANCE_PARAMETER = "instance";
        private final Class<?> target;
        private final List<InjectionMetadata.InjectedElement> injectedElements;

        AotContribution(Class<?> target, Collection<InjectionMetadata.InjectedElement> injectedElements) {
            this.target = target;
            this.injectedElements = List.copyOf(injectedElements);
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeatureComponent("PersistenceInjection", this.target, type -> {
                type.addJavadoc("Persistence injection for {@link $T}.", this.target);
                type.addModifiers(javax.lang.model.element.Modifier.PUBLIC);
            });
            GeneratedMethod generatedMethod = generatedClass.getMethods().add("apply", method -> {
                method.addJavadoc("Apply the persistence injection.", new Object[0]);
                method.addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC);
                method.addParameter((Type)((Object)RegisteredBean.class), REGISTERED_BEAN_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.addParameter(this.target, INSTANCE_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.returns(this.target);
                method.addCode(this.generateMethodCode(generationContext.getRuntimeHints(), generatedClass));
            });
            beanRegistrationCode.addInstancePostProcessor(generatedMethod.toMethodReference());
        }

        private CodeBlock generateMethodCode(RuntimeHints hints, GeneratedClass generatedClass) {
            CodeBlock.Builder code = CodeBlock.builder();
            if (this.injectedElements.size() == 1) {
                code.add(this.generateInjectedElementMethodCode(hints, generatedClass, this.injectedElements.get(0)));
            } else {
                for (InjectionMetadata.InjectedElement injectedElement : this.injectedElements) {
                    code.addStatement(this.applyInjectedElement(hints, generatedClass, injectedElement));
                }
            }
            code.addStatement("return $L", INSTANCE_PARAMETER);
            return code.build();
        }

        private CodeBlock applyInjectedElement(RuntimeHints hints, GeneratedClass generatedClass, InjectionMetadata.InjectedElement injectedElement) {
            String injectedElementName = injectedElement.getMember().getName();
            GeneratedMethod generatedMethod = generatedClass.getMethods().add(new String[]{"apply", injectedElementName}, method -> {
                method.addJavadoc("Apply the persistence injection for '$L'.", injectedElementName);
                method.addModifiers(javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC);
                method.addParameter((Type)((Object)RegisteredBean.class), REGISTERED_BEAN_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.addParameter(this.target, INSTANCE_PARAMETER, new javax.lang.model.element.Modifier[0]);
                method.addCode(this.generateInjectedElementMethodCode(hints, generatedClass, injectedElement));
            });
            MethodReference.ArgumentCodeGenerator argumentCodeGenerator = MethodReference.ArgumentCodeGenerator.of(RegisteredBean.class, REGISTERED_BEAN_PARAMETER).and(this.target, INSTANCE_PARAMETER);
            return generatedMethod.toMethodReference().toInvokeCodeBlock(argumentCodeGenerator, generatedClass.getName());
        }

        private CodeBlock generateInjectedElementMethodCode(RuntimeHints hints, GeneratedClass generatedClass, InjectionMetadata.InjectedElement injectedElement) {
            CodeBlock.Builder code = CodeBlock.builder();
            InjectionCodeGenerator injectionCodeGenerator = new InjectionCodeGenerator(generatedClass.getName(), hints);
            CodeBlock resourceToInject = this.generateResourceToInjectCode(generatedClass.getMethods(), (PersistenceElement)injectedElement);
            code.add(injectionCodeGenerator.generateInjectionCode(injectedElement.getMember(), INSTANCE_PARAMETER, resourceToInject));
            return code.build();
        }

        private CodeBlock generateResourceToInjectCode(GeneratedMethods generatedMethods, PersistenceElement injectedElement) {
            boolean requireEntityManager;
            String unitName = injectedElement.unitName;
            boolean bl = requireEntityManager = injectedElement.type != null;
            if (!requireEntityManager) {
                return CodeBlock.of("$T.findEntityManagerFactory(($T) $L.getBeanFactory(), $S)", EntityManagerFactoryUtils.class, ListableBeanFactory.class, REGISTERED_BEAN_PARAMETER, unitName);
            }
            String[] methodNameParts = new String[]{"get", unitName, "EntityManager"};
            GeneratedMethod generatedMethod = generatedMethods.add(methodNameParts, method -> this.generateGetEntityManagerMethod((MethodSpec.Builder)method, injectedElement));
            return CodeBlock.of("$L($L)", generatedMethod.getName(), REGISTERED_BEAN_PARAMETER);
        }

        private void generateGetEntityManagerMethod(MethodSpec.Builder method, PersistenceElement injectedElement) {
            boolean hasProperties;
            String unitName = injectedElement.unitName;
            Properties properties = injectedElement.properties;
            method.addJavadoc("Get the '$L' {@link $T}.", StringUtils.hasLength(unitName) ? unitName : "default", EntityManager.class);
            method.addModifiers(javax.lang.model.element.Modifier.PUBLIC, javax.lang.model.element.Modifier.STATIC);
            method.returns((Type)((Object)EntityManager.class));
            method.addParameter((Type)((Object)RegisteredBean.class), REGISTERED_BEAN_PARAMETER, new javax.lang.model.element.Modifier[0]);
            method.addStatement("$T entityManagerFactory = $T.findEntityManagerFactory(($T) $L.getBeanFactory(), $S)", EntityManagerFactory.class, EntityManagerFactoryUtils.class, ListableBeanFactory.class, REGISTERED_BEAN_PARAMETER, unitName);
            boolean bl = hasProperties = !CollectionUtils.isEmpty(properties);
            if (hasProperties) {
                method.addStatement("$T properties = new Properties()", Properties.class);
                for (String propertyName : new TreeSet<String>(properties.stringPropertyNames())) {
                    method.addStatement("properties.put($S, $S)", propertyName, properties.getProperty(propertyName));
                }
            }
            method.addStatement("return $T.createSharedEntityManager(entityManagerFactory, $L, $L)", SharedEntityManagerCreator.class, hasProperties ? "properties" : null, injectedElement.synchronizedWithTransaction);
        }
    }

    private class LocatorDelegate {
        private LocatorDelegate() {
        }

        public <T> T lookup(String jndiName, Class<T> requiredType) throws Exception {
            JndiLocatorDelegate locator = new JndiLocatorDelegate();
            Object object = PersistenceAnnotationBeanPostProcessor.this.jndiEnvironment;
            if (object instanceof JndiTemplate) {
                JndiTemplate jndiTemplate = (JndiTemplate)object;
                locator.setJndiTemplate(jndiTemplate);
            } else {
                object = PersistenceAnnotationBeanPostProcessor.this.jndiEnvironment;
                if (object instanceof Properties) {
                    Properties properties = (Properties)object;
                    locator.setJndiEnvironment(properties);
                } else if (PersistenceAnnotationBeanPostProcessor.this.jndiEnvironment != null) {
                    throw new IllegalStateException("Illegal 'jndiEnvironment' type: " + String.valueOf(PersistenceAnnotationBeanPostProcessor.this.jndiEnvironment.getClass()));
                }
            }
            locator.setResourceRef(PersistenceAnnotationBeanPostProcessor.this.resourceRef);
            return locator.lookup(jndiName, requiredType);
        }
    }

    private class PersistenceElement
    extends InjectionMetadata.InjectedElement {
        private final String unitName;
        @Nullable
        private PersistenceContextType type;
        private boolean synchronizedWithTransaction;
        @Nullable
        private Properties properties;

        public PersistenceElement(Member member, @Nullable AnnotatedElement ae, PropertyDescriptor pd) {
            super(member, pd);
            this.synchronizedWithTransaction = false;
            PersistenceContext pc = ae.getAnnotation(PersistenceContext.class);
            PersistenceUnit pu = ae.getAnnotation(PersistenceUnit.class);
            Class resourceType = EntityManager.class;
            if (pc != null) {
                if (pu != null) {
                    throw new IllegalStateException("Member may only be annotated with either @PersistenceContext or @PersistenceUnit, not both: " + String.valueOf(member));
                }
                Properties properties = null;
                Object[] pps = pc.properties();
                if (!ObjectUtils.isEmpty(pps)) {
                    properties = new Properties();
                    for (Object pp : pps) {
                        properties.setProperty(pp.name(), pp.value());
                    }
                }
                this.unitName = pc.unitName();
                this.type = pc.type();
                this.synchronizedWithTransaction = SynchronizationType.SYNCHRONIZED.equals((Object)pc.synchronization());
                this.properties = properties;
            } else {
                resourceType = EntityManagerFactory.class;
                this.unitName = pu.unitName();
            }
            this.checkResourceType(resourceType);
        }

        @Override
        protected Object getResourceToInject(Object target, @Nullable String requestingBeanName) {
            if (this.type != null) {
                return this.type == PersistenceContextType.EXTENDED ? this.resolveExtendedEntityManager(target, requestingBeanName) : this.resolveEntityManager(requestingBeanName);
            }
            return this.resolveEntityManagerFactory(requestingBeanName);
        }

        private EntityManagerFactory resolveEntityManagerFactory(@Nullable String requestingBeanName) {
            EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
            if (emf == null) {
                emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
            }
            return emf;
        }

        private EntityManager resolveEntityManager(@Nullable String requestingBeanName) {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, false);
            if (em == null) {
                EntityManagerFactoryInfo emfInfo;
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
                }
                em = emf instanceof EntityManagerFactoryInfo && (emfInfo = (EntityManagerFactoryInfo)((Object)emf)).getEntityManagerInterface() != null ? SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties, this.synchronizedWithTransaction) : SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties, this.synchronizedWithTransaction, this.getResourceType());
            }
            return em;
        }

        private EntityManager resolveExtendedEntityManager(Object target, @Nullable String requestingBeanName) {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, true);
            if (em == null) {
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
                }
                em = ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, this.properties, this.synchronizedWithTransaction);
            }
            if (em instanceof EntityManagerProxy) {
                EntityManagerProxy emp = (EntityManagerProxy)em;
                if (PersistenceAnnotationBeanPostProcessor.this.beanFactory != null && requestingBeanName != null && PersistenceAnnotationBeanPostProcessor.this.beanFactory.containsBean(requestingBeanName) && !PersistenceAnnotationBeanPostProcessor.this.beanFactory.isPrototype(requestingBeanName)) {
                    PersistenceAnnotationBeanPostProcessor.this.extendedEntityManagersToClose.put(target, emp.getTargetEntityManager());
                }
            }
            return em;
        }
    }
}

