/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManagerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jpa.DefaultTransactionStrategy;
import org.apache.camel.component.jpa.JpaEndpoint;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="jpa")
public class JpaComponent
extends HealthCheckComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JpaComponent.class);
    private ExecutorService pollingConsumerExecutorService;
    @Metadata
    private EntityManagerFactory entityManagerFactory;
    @Metadata
    private TransactionStrategy transactionStrategy;
    @Metadata(defaultValue="true")
    private boolean joinTransaction = true;
    @Metadata
    private boolean sharedEntityManager;
    @Metadata
    private Map<String, Class<?>> aliases = new HashMap();

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public TransactionStrategy getTransactionStrategy() {
        return this.transactionStrategy;
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public void addAlias(String alias, Class<?> clazz) {
        this.aliases.put(alias, clazz);
    }

    public void setAliases(Map<String, Class<?>> aliases) {
        this.aliases = aliases;
    }

    public Map<String, Class<?>> getAliases() {
        return this.aliases;
    }

    synchronized ExecutorService getOrCreatePollingConsumerExecutorService() {
        if (this.pollingConsumerExecutorService == null) {
            LOG.debug("Creating thread pool for JpaPollingConsumer to support polling using timeout");
            this.pollingConsumerExecutorService = this.getCamelContext().getExecutorServiceManager().newDefaultThreadPool(this, "JpaPollingConsumer");
        }
        return this.pollingConsumerExecutorService;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String path, Map<String, Object> options) throws Exception {
        JpaEndpoint endpoint = new JpaEndpoint(uri, this);
        endpoint.setJoinTransaction(this.isJoinTransaction());
        endpoint.setSharedEntityManager(this.isSharedEntityManager());
        Map<String, Object> params = PropertiesHelper.extractProperties(options, "parameters.", true);
        if (!params.isEmpty()) {
            endpoint.setParameters(params);
        }
        if (ObjectHelper.isNotEmpty(path)) {
            Class<?> type = this.aliases.get(path);
            if (type == null) {
                type = this.getCamelContext().getClassResolver().resolveClass(path, JpaComponent.class.getClassLoader());
            }
            if (type != null) {
                endpoint.setEntityType(type);
            }
        }
        this.setProperties(endpoint, options);
        return endpoint;
    }

    private void initEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            Map<String, EntityManagerFactory> map = this.getCamelContext().getRegistry().findByTypeWithName(EntityManagerFactory.class);
            if (map != null) {
                if (map.size() == 1) {
                    this.entityManagerFactory = map.values().iterator().next();
                    LOG.info("Using EntityManagerFactory found in registry with id [{}] {}", (Object)map.keySet().iterator().next(), (Object)this.entityManagerFactory);
                } else {
                    LOG.debug("Could not find a single EntityManagerFactory in registry as there was {} instances.", (Object)map.size());
                }
            }
        } else {
            LOG.info("Using EntityManagerFactory configured: {}", (Object)this.entityManagerFactory);
        }
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.initEntityManagerFactory();
        if (this.entityManagerFactory == null) {
            LOG.warn("No EntityManagerFactory has been configured on this JpaComponent. Each JpaEndpoint will auto create their own EntityManagerFactory.");
        }
        if (this.transactionStrategy != null) {
            LOG.info("Using TransactionStrategy configured: {}", (Object)this.transactionStrategy);
        } else {
            this.createTransactionStrategy();
        }
    }

    private void createTransactionStrategy() {
        if (this.transactionStrategy == null && this.getEntityManagerFactory() != null) {
            this.transactionStrategy = new DefaultTransactionStrategy(this.getCamelContext(), this.getEntityManagerFactory());
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.pollingConsumerExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdown(this.pollingConsumerExecutorService);
            this.pollingConsumerExecutorService = null;
        }
    }
}

