/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.time.Duration;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.strategy.FileMoveExistingStrategy;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;

public class FtpEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FtpEndpoint target = (FtpEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "account": {
                target.getConfiguration().setAccount(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "activeportrange": 
            case "activePortRange": {
                target.getConfiguration().setActivePortRange(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "allownullbody": 
            case "allowNullBody": {
                target.setAllowNullBody(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "antexclude": 
            case "antExclude": {
                target.setAntExclude(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "antfiltercasesensitive": 
            case "antFilterCaseSensitive": {
                target.setAntFilterCaseSensitive(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "antinclude": 
            case "antInclude": {
                target.setAntInclude(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "autocreate": 
            case "autoCreate": {
                target.setAutoCreate(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "binary": {
                target.getConfiguration().setBinary(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                target.setBufferSize(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "charset": {
                target.setCharset(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                target.setChecksumFileAlgorithm(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "chmod": {
                target.getConfiguration().setChmod(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                target.getConfiguration().setConnectTimeout(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "delay": {
                target.setDelay(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "delete": {
                target.setDelete(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "disconnect": {
                target.setDisconnect(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                target.setDisconnectOnBatchComplete(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "donefilename": 
            case "doneFileName": {
                target.setDoneFileName(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "download": {
                target.setDownload(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "eagerdeletetargetfile": 
            case "eagerDeleteTargetFile": {
                target.setEagerDeleteTargetFile(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "eagermaxmessagesperpoll": 
            case "eagerMaxMessagesPerPoll": {
                target.setEagerMaxMessagesPerPoll(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(FtpEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(FtpEndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "exclude": {
                target.setExclude(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "excludeext": 
            case "excludeExt": {
                target.setExcludeExt(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "exclusivereadlockstrategy": 
            case "exclusiveReadLockStrategy": {
                target.setExclusiveReadLockStrategy(FtpEndpointConfigurer.property(camelContext, GenericFileExclusiveReadLockStrategy.class, value));
                return true;
            }
            case "fastexistscheck": 
            case "fastExistsCheck": {
                target.setFastExistsCheck(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "fileexist": 
            case "fileExist": {
                target.setFileExist(FtpEndpointConfigurer.property(camelContext, GenericFileExist.class, value));
                return true;
            }
            case "filename": 
            case "fileName": {
                target.setFileName(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "filter": {
                target.setFilter(FtpEndpointConfigurer.property(camelContext, GenericFileFilter.class, value));
                return true;
            }
            case "filterdirectory": 
            case "filterDirectory": {
                target.setFilterDirectory(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "filterfile": 
            case "filterFile": {
                target.setFilterFile(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "flatten": {
                target.setFlatten(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "ftpclient": 
            case "ftpClient": {
                target.setFtpClient(FtpEndpointConfigurer.property(camelContext, FTPClient.class, value));
                return true;
            }
            case "ftpclientconfig": 
            case "ftpClientConfig": {
                target.setFtpClientConfig(FtpEndpointConfigurer.property(camelContext, FTPClientConfig.class, value));
                return true;
            }
            case "ftpclientconfigparameters": 
            case "ftpClientConfigParameters": {
                target.setFtpClientConfigParameters(FtpEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "ftpclientparameters": 
            case "ftpClientParameters": {
                target.setFtpClientParameters(FtpEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "greedy": {
                target.setGreedy(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "handledirectoryparserabsoluteresult": 
            case "handleDirectoryParserAbsoluteResult": {
                target.getConfiguration().setHandleDirectoryParserAbsoluteResult(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "idempotent": {
                target.setIdempotent(FtpEndpointConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "idempotenteager": 
            case "idempotentEager": {
                target.setIdempotentEager(FtpEndpointConfigurer.property(camelContext, Boolean.class, value));
                return true;
            }
            case "idempotentkey": 
            case "idempotentKey": {
                target.setIdempotentKey(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "idempotentrepository": 
            case "idempotentRepository": {
                target.setIdempotentRepository(FtpEndpointConfigurer.property(camelContext, IdempotentRepository.class, value));
                return true;
            }
            case "ignorefilenotfoundorpermissionerror": 
            case "ignoreFileNotFoundOrPermissionError": {
                target.getConfiguration().setIgnoreFileNotFoundOrPermissionError(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "inprogressrepository": 
            case "inProgressRepository": {
                target.setInProgressRepository(FtpEndpointConfigurer.property(camelContext, IdempotentRepository.class, value));
                return true;
            }
            case "include": {
                target.setInclude(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "includeext": 
            case "includeExt": {
                target.setIncludeExt(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                target.setJailStartingDirectory(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "keeplastmodified": 
            case "keepLastModified": {
                target.setKeepLastModified(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "localworkdirectory": 
            case "localWorkDirectory": {
                target.setLocalWorkDirectory(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "maxdepth": 
            case "maxDepth": {
                target.setMaxDepth(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                target.setMaxMessagesPerPoll(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "maximumreconnectattempts": 
            case "maximumReconnectAttempts": {
                target.setMaximumReconnectAttempts(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "mindepth": 
            case "minDepth": {
                target.setMinDepth(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "move": {
                target.setMove(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "moveexisting": 
            case "moveExisting": {
                target.setMoveExisting(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                target.setMoveExistingFileStrategy(FtpEndpointConfigurer.property(camelContext, FileMoveExistingStrategy.class, value));
                return true;
            }
            case "movefailed": 
            case "moveFailed": {
                target.setMoveFailed(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "noop": {
                target.setNoop(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "oncompletionexceptionhandler": 
            case "onCompletionExceptionHandler": {
                target.setOnCompletionExceptionHandler(FtpEndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "passivemode": 
            case "passiveMode": {
                target.getConfiguration().setPassiveMode(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy(FtpEndpointConfigurer.property(camelContext, PollingConsumerPollStrategy.class, value));
                return true;
            }
            case "premove": 
            case "preMove": {
                target.setPreMove(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "presort": 
            case "preSort": {
                target.setPreSort(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "processstrategy": 
            case "processStrategy": {
                target.setProcessStrategy(FtpEndpointConfigurer.property(camelContext, GenericFileProcessStrategy.class, value));
                return true;
            }
            case "readlock": 
            case "readLock": {
                target.setReadLock(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "readlockcheckinterval": 
            case "readLockCheckInterval": {
                target.setReadLockCheckInterval(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "readlockdeleteorphanlockfiles": 
            case "readLockDeleteOrphanLockFiles": {
                target.setReadLockDeleteOrphanLockFiles(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "readlocklogginglevel": 
            case "readLockLoggingLevel": {
                target.setReadLockLoggingLevel(FtpEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "readlockmarkerfile": 
            case "readLockMarkerFile": {
                target.setReadLockMarkerFile(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "readlockminage": 
            case "readLockMinAge": {
                target.setReadLockMinAge(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "readlockminlength": 
            case "readLockMinLength": {
                target.setReadLockMinLength(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "readlockremoveoncommit": 
            case "readLockRemoveOnCommit": {
                target.setReadLockRemoveOnCommit(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "readlockremoveonrollback": 
            case "readLockRemoveOnRollback": {
                target.setReadLockRemoveOnRollback(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "readlocktimeout": 
            case "readLockTimeout": {
                target.setReadLockTimeout(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "reconnectdelay": 
            case "reconnectDelay": {
                target.setReconnectDelay(FtpEndpointConfigurer.property(camelContext, Duration.class, value).toMillis());
                return true;
            }
            case "recursive": {
                target.setRecursive(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(FtpEndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "resumedownload": 
            case "resumeDownload": {
                target.setResumeDownload(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(FtpEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService(FtpEndpointConfigurer.property(camelContext, ScheduledExecutorService.class, value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(FtpEndpointConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties(FtpEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sendnoop": 
            case "sendNoop": {
                target.getConfiguration().setSendNoop(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "separator": {
                target.getConfiguration().setSeparator(FtpEndpointConfigurer.property(camelContext, RemoteFileConfiguration.PathSeparator.class, value));
                return true;
            }
            case "shuffle": {
                target.setShuffle(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sitecommand": 
            case "siteCommand": {
                target.getConfiguration().setSiteCommand(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sotimeout": 
            case "soTimeout": {
                target.getConfiguration().setSoTimeout(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "sortby": 
            case "sortBy": {
                target.setSortBy(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sorter": {
                target.setSorter(FtpEndpointConfigurer.property(camelContext, Comparator.class, value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "stepwise": {
                target.getConfiguration().setStepwise(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "streamdownload": 
            case "streamDownload": {
                target.getConfiguration().setStreamDownload(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "tempfilename": 
            case "tempFileName": {
                target.setTempFileName(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "tempprefix": 
            case "tempPrefix": {
                target.setTempPrefix(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "throwexceptiononconnectfailed": 
            case "throwExceptionOnConnectFailed": {
                target.getConfiguration().setThrowExceptionOnConnectFailed(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit(FtpEndpointConfigurer.property(camelContext, TimeUnit.class, value));
                return true;
            }
            case "timeout": {
                target.getConfiguration().setTimeout(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "transferloggingintervalseconds": 
            case "transferLoggingIntervalSeconds": {
                target.setTransferLoggingIntervalSeconds(FtpEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "transferlogginglevel": 
            case "transferLoggingLevel": {
                target.setTransferLoggingLevel(FtpEndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "transferloggingverbose": 
            case "transferLoggingVerbose": {
                target.setTransferLoggingVerbose(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "uselist": 
            case "useList": {
                target.getConfiguration().setUseList(FtpEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                target.getConfiguration().setUsername(FtpEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "account": {
                return String.class;
            }
            case "activeportrange": 
            case "activePortRange": {
                return String.class;
            }
            case "allownullbody": 
            case "allowNullBody": {
                return Boolean.TYPE;
            }
            case "antexclude": 
            case "antExclude": {
                return String.class;
            }
            case "antfiltercasesensitive": 
            case "antFilterCaseSensitive": {
                return Boolean.TYPE;
            }
            case "antinclude": 
            case "antInclude": {
                return String.class;
            }
            case "autocreate": 
            case "autoCreate": {
                return Boolean.TYPE;
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "binary": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "buffersize": 
            case "bufferSize": {
                return Integer.TYPE;
            }
            case "charset": {
                return String.class;
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                return String.class;
            }
            case "chmod": {
                return String.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "delete": {
                return Boolean.TYPE;
            }
            case "disconnect": {
                return Boolean.TYPE;
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                return Boolean.TYPE;
            }
            case "donefilename": 
            case "doneFileName": {
                return String.class;
            }
            case "download": {
                return Boolean.TYPE;
            }
            case "eagerdeletetargetfile": 
            case "eagerDeleteTargetFile": {
                return Boolean.TYPE;
            }
            case "eagermaxmessagesperpoll": 
            case "eagerMaxMessagesPerPoll": {
                return Boolean.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "exclude": {
                return String.class;
            }
            case "excludeext": 
            case "excludeExt": {
                return String.class;
            }
            case "exclusivereadlockstrategy": 
            case "exclusiveReadLockStrategy": {
                return GenericFileExclusiveReadLockStrategy.class;
            }
            case "fastexistscheck": 
            case "fastExistsCheck": {
                return Boolean.TYPE;
            }
            case "fileexist": 
            case "fileExist": {
                return GenericFileExist.class;
            }
            case "filename": 
            case "fileName": {
                return String.class;
            }
            case "filter": {
                return GenericFileFilter.class;
            }
            case "filterdirectory": 
            case "filterDirectory": {
                return String.class;
            }
            case "filterfile": 
            case "filterFile": {
                return String.class;
            }
            case "flatten": {
                return Boolean.TYPE;
            }
            case "ftpclient": 
            case "ftpClient": {
                return FTPClient.class;
            }
            case "ftpclientconfig": 
            case "ftpClientConfig": {
                return FTPClientConfig.class;
            }
            case "ftpclientconfigparameters": 
            case "ftpClientConfigParameters": {
                return Map.class;
            }
            case "ftpclientparameters": 
            case "ftpClientParameters": {
                return Map.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "handledirectoryparserabsoluteresult": 
            case "handleDirectoryParserAbsoluteResult": {
                return Boolean.TYPE;
            }
            case "idempotent": {
                return Boolean.class;
            }
            case "idempotenteager": 
            case "idempotentEager": {
                return Boolean.class;
            }
            case "idempotentkey": 
            case "idempotentKey": {
                return String.class;
            }
            case "idempotentrepository": 
            case "idempotentRepository": {
                return IdempotentRepository.class;
            }
            case "ignorefilenotfoundorpermissionerror": 
            case "ignoreFileNotFoundOrPermissionError": {
                return Boolean.TYPE;
            }
            case "inprogressrepository": 
            case "inProgressRepository": {
                return IdempotentRepository.class;
            }
            case "include": {
                return String.class;
            }
            case "includeext": 
            case "includeExt": {
                return String.class;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                return Boolean.TYPE;
            }
            case "keeplastmodified": 
            case "keepLastModified": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "localworkdirectory": 
            case "localWorkDirectory": {
                return String.class;
            }
            case "maxdepth": 
            case "maxDepth": {
                return Integer.TYPE;
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return Integer.TYPE;
            }
            case "maximumreconnectattempts": 
            case "maximumReconnectAttempts": {
                return Integer.TYPE;
            }
            case "mindepth": 
            case "minDepth": {
                return Integer.TYPE;
            }
            case "move": {
                return String.class;
            }
            case "moveexisting": 
            case "moveExisting": {
                return String.class;
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                return FileMoveExistingStrategy.class;
            }
            case "movefailed": 
            case "moveFailed": {
                return String.class;
            }
            case "noop": {
                return Boolean.TYPE;
            }
            case "oncompletionexceptionhandler": 
            case "onCompletionExceptionHandler": {
                return ExceptionHandler.class;
            }
            case "passivemode": 
            case "passiveMode": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "premove": 
            case "preMove": {
                return String.class;
            }
            case "presort": 
            case "preSort": {
                return Boolean.TYPE;
            }
            case "processstrategy": 
            case "processStrategy": {
                return GenericFileProcessStrategy.class;
            }
            case "readlock": 
            case "readLock": {
                return String.class;
            }
            case "readlockcheckinterval": 
            case "readLockCheckInterval": {
                return Long.TYPE;
            }
            case "readlockdeleteorphanlockfiles": 
            case "readLockDeleteOrphanLockFiles": {
                return Boolean.TYPE;
            }
            case "readlocklogginglevel": 
            case "readLockLoggingLevel": {
                return LoggingLevel.class;
            }
            case "readlockmarkerfile": 
            case "readLockMarkerFile": {
                return Boolean.TYPE;
            }
            case "readlockminage": 
            case "readLockMinAge": {
                return Long.TYPE;
            }
            case "readlockminlength": 
            case "readLockMinLength": {
                return Long.TYPE;
            }
            case "readlockremoveoncommit": 
            case "readLockRemoveOnCommit": {
                return Boolean.TYPE;
            }
            case "readlockremoveonrollback": 
            case "readLockRemoveOnRollback": {
                return Boolean.TYPE;
            }
            case "readlocktimeout": 
            case "readLockTimeout": {
                return Long.TYPE;
            }
            case "reconnectdelay": 
            case "reconnectDelay": {
                return Long.TYPE;
            }
            case "recursive": {
                return Boolean.TYPE;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "resumedownload": 
            case "resumeDownload": {
                return Boolean.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "sendnoop": 
            case "sendNoop": {
                return Boolean.TYPE;
            }
            case "separator": {
                return RemoteFileConfiguration.PathSeparator.class;
            }
            case "shuffle": {
                return Boolean.TYPE;
            }
            case "sitecommand": 
            case "siteCommand": {
                return String.class;
            }
            case "sotimeout": 
            case "soTimeout": {
                return Integer.TYPE;
            }
            case "sortby": 
            case "sortBy": {
                return String.class;
            }
            case "sorter": {
                return Comparator.class;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "stepwise": {
                return Boolean.TYPE;
            }
            case "streamdownload": 
            case "streamDownload": {
                return Boolean.TYPE;
            }
            case "tempfilename": 
            case "tempFileName": {
                return String.class;
            }
            case "tempprefix": 
            case "tempPrefix": {
                return String.class;
            }
            case "throwexceptiononconnectfailed": 
            case "throwExceptionOnConnectFailed": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "timeout": {
                return Integer.TYPE;
            }
            case "transferloggingintervalseconds": 
            case "transferLoggingIntervalSeconds": {
                return Integer.TYPE;
            }
            case "transferlogginglevel": 
            case "transferLoggingLevel": {
                return LoggingLevel.class;
            }
            case "transferloggingverbose": 
            case "transferLoggingVerbose": {
                return Boolean.TYPE;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "uselist": 
            case "useList": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FtpEndpoint target = (FtpEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "account": {
                return target.getConfiguration().getAccount();
            }
            case "activeportrange": 
            case "activePortRange": {
                return target.getConfiguration().getActivePortRange();
            }
            case "allownullbody": 
            case "allowNullBody": {
                return target.isAllowNullBody();
            }
            case "antexclude": 
            case "antExclude": {
                return target.getAntExclude();
            }
            case "antfiltercasesensitive": 
            case "antFilterCaseSensitive": {
                return target.isAntFilterCaseSensitive();
            }
            case "antinclude": 
            case "antInclude": {
                return target.getAntInclude();
            }
            case "autocreate": 
            case "autoCreate": {
                return target.isAutoCreate();
            }
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "binary": {
                return target.getConfiguration().isBinary();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "buffersize": 
            case "bufferSize": {
                return target.getBufferSize();
            }
            case "charset": {
                return target.getCharset();
            }
            case "checksumfilealgorithm": 
            case "checksumFileAlgorithm": {
                return target.getChecksumFileAlgorithm();
            }
            case "chmod": {
                return target.getConfiguration().getChmod();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return target.getConfiguration().getConnectTimeout();
            }
            case "delay": {
                return target.getDelay();
            }
            case "delete": {
                return target.isDelete();
            }
            case "disconnect": {
                return target.isDisconnect();
            }
            case "disconnectonbatchcomplete": 
            case "disconnectOnBatchComplete": {
                return target.isDisconnectOnBatchComplete();
            }
            case "donefilename": 
            case "doneFileName": {
                return target.getDoneFileName();
            }
            case "download": {
                return target.isDownload();
            }
            case "eagerdeletetargetfile": 
            case "eagerDeleteTargetFile": {
                return target.isEagerDeleteTargetFile();
            }
            case "eagermaxmessagesperpoll": 
            case "eagerMaxMessagesPerPoll": {
                return target.isEagerMaxMessagesPerPoll();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "exclude": {
                return target.getExclude();
            }
            case "excludeext": 
            case "excludeExt": {
                return target.getExcludeExt();
            }
            case "exclusivereadlockstrategy": 
            case "exclusiveReadLockStrategy": {
                return target.getExclusiveReadLockStrategy();
            }
            case "fastexistscheck": 
            case "fastExistsCheck": {
                return target.isFastExistsCheck();
            }
            case "fileexist": 
            case "fileExist": {
                return target.getFileExist();
            }
            case "filename": 
            case "fileName": {
                return target.getFileName();
            }
            case "filter": {
                return target.getFilter();
            }
            case "filterdirectory": 
            case "filterDirectory": {
                return target.getFilterDirectory();
            }
            case "filterfile": 
            case "filterFile": {
                return target.getFilterFile();
            }
            case "flatten": {
                return target.isFlatten();
            }
            case "ftpclient": 
            case "ftpClient": {
                return target.getFtpClient();
            }
            case "ftpclientconfig": 
            case "ftpClientConfig": {
                return target.getFtpClientConfig();
            }
            case "ftpclientconfigparameters": 
            case "ftpClientConfigParameters": {
                return target.getFtpClientConfigParameters();
            }
            case "ftpclientparameters": 
            case "ftpClientParameters": {
                return target.getFtpClientParameters();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "handledirectoryparserabsoluteresult": 
            case "handleDirectoryParserAbsoluteResult": {
                return target.getConfiguration().isHandleDirectoryParserAbsoluteResult();
            }
            case "idempotent": {
                return target.getIdempotent();
            }
            case "idempotenteager": 
            case "idempotentEager": {
                return target.getIdempotentEager();
            }
            case "idempotentkey": 
            case "idempotentKey": {
                return target.getIdempotentKey();
            }
            case "idempotentrepository": 
            case "idempotentRepository": {
                return target.getIdempotentRepository();
            }
            case "ignorefilenotfoundorpermissionerror": 
            case "ignoreFileNotFoundOrPermissionError": {
                return target.getConfiguration().isIgnoreFileNotFoundOrPermissionError();
            }
            case "inprogressrepository": 
            case "inProgressRepository": {
                return target.getInProgressRepository();
            }
            case "include": {
                return target.getInclude();
            }
            case "includeext": 
            case "includeExt": {
                return target.getIncludeExt();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "jailstartingdirectory": 
            case "jailStartingDirectory": {
                return target.isJailStartingDirectory();
            }
            case "keeplastmodified": 
            case "keepLastModified": {
                return target.isKeepLastModified();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "localworkdirectory": 
            case "localWorkDirectory": {
                return target.getLocalWorkDirectory();
            }
            case "maxdepth": 
            case "maxDepth": {
                return target.getMaxDepth();
            }
            case "maxmessagesperpoll": 
            case "maxMessagesPerPoll": {
                return target.getMaxMessagesPerPoll();
            }
            case "maximumreconnectattempts": 
            case "maximumReconnectAttempts": {
                return target.getMaximumReconnectAttempts();
            }
            case "mindepth": 
            case "minDepth": {
                return target.getMinDepth();
            }
            case "move": {
                return target.getMove();
            }
            case "moveexisting": 
            case "moveExisting": {
                return target.getMoveExisting();
            }
            case "moveexistingfilestrategy": 
            case "moveExistingFileStrategy": {
                return target.getMoveExistingFileStrategy();
            }
            case "movefailed": 
            case "moveFailed": {
                return target.getMoveFailed();
            }
            case "noop": {
                return target.isNoop();
            }
            case "oncompletionexceptionhandler": 
            case "onCompletionExceptionHandler": {
                return target.getOnCompletionExceptionHandler();
            }
            case "passivemode": 
            case "passiveMode": {
                return target.getConfiguration().isPassiveMode();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "premove": 
            case "preMove": {
                return target.getPreMove();
            }
            case "presort": 
            case "preSort": {
                return target.isPreSort();
            }
            case "processstrategy": 
            case "processStrategy": {
                return target.getProcessStrategy();
            }
            case "readlock": 
            case "readLock": {
                return target.getReadLock();
            }
            case "readlockcheckinterval": 
            case "readLockCheckInterval": {
                return target.getReadLockCheckInterval();
            }
            case "readlockdeleteorphanlockfiles": 
            case "readLockDeleteOrphanLockFiles": {
                return target.isReadLockDeleteOrphanLockFiles();
            }
            case "readlocklogginglevel": 
            case "readLockLoggingLevel": {
                return target.getReadLockLoggingLevel();
            }
            case "readlockmarkerfile": 
            case "readLockMarkerFile": {
                return target.isReadLockMarkerFile();
            }
            case "readlockminage": 
            case "readLockMinAge": {
                return target.getReadLockMinAge();
            }
            case "readlockminlength": 
            case "readLockMinLength": {
                return target.getReadLockMinLength();
            }
            case "readlockremoveoncommit": 
            case "readLockRemoveOnCommit": {
                return target.isReadLockRemoveOnCommit();
            }
            case "readlockremoveonrollback": 
            case "readLockRemoveOnRollback": {
                return target.isReadLockRemoveOnRollback();
            }
            case "readlocktimeout": 
            case "readLockTimeout": {
                return target.getReadLockTimeout();
            }
            case "reconnectdelay": 
            case "reconnectDelay": {
                return target.getReconnectDelay();
            }
            case "recursive": {
                return target.isRecursive();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "resumedownload": 
            case "resumeDownload": {
                return target.isResumeDownload();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "sendnoop": 
            case "sendNoop": {
                return target.getConfiguration().isSendNoop();
            }
            case "separator": {
                return target.getConfiguration().getSeparator();
            }
            case "shuffle": {
                return target.isShuffle();
            }
            case "sitecommand": 
            case "siteCommand": {
                return target.getConfiguration().getSiteCommand();
            }
            case "sotimeout": 
            case "soTimeout": {
                return target.getConfiguration().getSoTimeout();
            }
            case "sortby": 
            case "sortBy": {
                return target.getSortBy();
            }
            case "sorter": {
                return target.getSorter();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "stepwise": {
                return target.getConfiguration().isStepwise();
            }
            case "streamdownload": 
            case "streamDownload": {
                return target.getConfiguration().isStreamDownload();
            }
            case "tempfilename": 
            case "tempFileName": {
                return target.getTempFileName();
            }
            case "tempprefix": 
            case "tempPrefix": {
                return target.getTempPrefix();
            }
            case "throwexceptiononconnectfailed": 
            case "throwExceptionOnConnectFailed": {
                return target.getConfiguration().isThrowExceptionOnConnectFailed();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "timeout": {
                return target.getConfiguration().getTimeout();
            }
            case "transferloggingintervalseconds": 
            case "transferLoggingIntervalSeconds": {
                return target.getTransferLoggingIntervalSeconds();
            }
            case "transferlogginglevel": 
            case "transferLoggingLevel": {
                return target.getTransferLoggingLevel();
            }
            case "transferloggingverbose": 
            case "transferLoggingVerbose": {
                return target.isTransferLoggingVerbose();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "uselist": 
            case "useList": {
                return target.getConfiguration().isUseList();
            }
            case "username": {
                return target.getConfiguration().getUsername();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "exclusivereadlockstrategy": 
            case "exclusiveReadLockStrategy": {
                return FTPFile.class;
            }
            case "filter": {
                return FTPFile.class;
            }
            case "ftpclientconfigparameters": 
            case "ftpClientConfigParameters": {
                return Object.class;
            }
            case "ftpclientparameters": 
            case "ftpClientParameters": {
                return Object.class;
            }
            case "processstrategy": 
            case "processStrategy": {
                return FTPFile.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
            case "sorter": {
                return GenericFile.class;
            }
        }
        return null;
    }
}

