/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Expression;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="delay")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DelayDefinition
extends ExpressionNode
implements ExecutorServiceAwareDefinition<DelayDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String asyncDelayed;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean", defaultValue="true")
    private String callerRunsWhenRejected;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;

    public DelayDefinition() {
    }

    protected DelayDefinition(DelayDefinition source) {
        super(source);
        this.executorServiceBean = source.executorServiceBean;
        this.asyncDelayed = source.asyncDelayed;
        this.callerRunsWhenRejected = source.callerRunsWhenRejected;
        this.executorService = source.executorService;
    }

    public DelayDefinition(Expression delay) {
        super(delay);
    }

    @Override
    public DelayDefinition copyDefinition() {
        return new DelayDefinition(this);
    }

    @Override
    public String getShortName() {
        return "delay";
    }

    @Override
    public String getLabel() {
        return "delay[" + String.valueOf(this.getExpression()) + "]";
    }

    public String toString() {
        return "Delay[" + String.valueOf(this.getExpression()) + " -> " + String.valueOf(this.getOutputs()) + "]";
    }

    public DelayDefinition delayTime(Long delay) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(ExpressionBuilder.constantExpression(delay)));
        return this;
    }

    public DelayDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
        return this;
    }

    public DelayDefinition callerRunsWhenRejected(String callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public DelayDefinition asyncDelayed() {
        this.setAsyncDelayed(Boolean.toString(true));
        return this;
    }

    public DelayDefinition asyncDelayed(String asyncDelayed) {
        this.setAsyncDelayed(asyncDelayed);
        return this;
    }

    public DelayDefinition syncDelayed() {
        this.setAsyncDelayed(Boolean.toString(false));
        return this;
    }

    @Override
    public DelayDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public DelayDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getAsyncDelayed() {
        return this.asyncDelayed;
    }

    public void setAsyncDelayed(String asyncDelayed) {
        this.asyncDelayed = asyncDelayed;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

