/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.cli;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.schibsted.spt.data.jslt.Expression;
import com.schibsted.spt.data.jslt.Parser;
import java.io.File;

public class JSLT {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java com.schibsted.spt.data.jslt.cli.JSLT <jslt file> <json input file>");
            System.exit(1);
        }
        Expression expr = Parser.compile(new File(args[0]));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode input = null;
        try {
            input = mapper.readTree(new File(args[1]));
        }
        catch (JsonParseException e) {
            System.out.println("Couldn't parse JSON file '" + args[1] + "': " + e.getMessage());
            System.exit(1);
        }
        JsonNode output = expr.apply(input);
        if (output == null) {
            System.out.println("WARN: returned Java null!");
        }
        System.out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(output));
    }
}

