/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.impl.AbstractOperator;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;

public class EqualsComparison
extends AbstractOperator {
    public EqualsComparison(ExpressionNode left, ExpressionNode right, Location location) {
        super(left, right, "==", location);
    }

    @Override
    public JsonNode perform(JsonNode v1, JsonNode v2) {
        return NodeUtils.toJson(EqualsComparison.equals(v1, v2));
    }

    public static boolean equals(JsonNode v1, JsonNode v2) {
        if (v1.isNumber() && v2.isNumber()) {
            if (v1.isIntegralNumber() && v2.isIntegralNumber()) {
                return v1.longValue() == v2.longValue();
            }
            return v1.doubleValue() == v2.doubleValue();
        }
        return v1.equals(v2);
    }
}

