/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jslt;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jslt.JsltEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JsltEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JsltEndpoint target = (JsltEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                target.setAllowContextMapAll(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                target.setAllowTemplateFromHeader(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "contentcache": 
            case "contentCache": {
                target.setContentCache(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "mapbigdecimalasfloats": 
            case "mapBigDecimalAsFloats": {
                target.setMapBigDecimalAsFloats(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "objectmapper": 
            case "objectMapper": {
                target.setObjectMapper(JsltEndpointConfigurer.property(camelContext, ObjectMapper.class, value));
                return true;
            }
            case "prettyprint": 
            case "prettyPrint": {
                target.setPrettyPrint(JsltEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return Boolean.TYPE;
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return Boolean.TYPE;
            }
            case "contentcache": 
            case "contentCache": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "mapbigdecimalasfloats": 
            case "mapBigDecimalAsFloats": {
                return Boolean.TYPE;
            }
            case "objectmapper": 
            case "objectMapper": {
                return ObjectMapper.class;
            }
            case "prettyprint": 
            case "prettyPrint": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JsltEndpoint target = (JsltEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allowcontextmapall": 
            case "allowContextMapAll": {
                return target.isAllowContextMapAll();
            }
            case "allowtemplatefromheader": 
            case "allowTemplateFromHeader": {
                return target.isAllowTemplateFromHeader();
            }
            case "contentcache": 
            case "contentCache": {
                return target.isContentCache();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "mapbigdecimalasfloats": 
            case "mapBigDecimalAsFloats": {
                return target.isMapBigDecimalAsFloats();
            }
            case "objectmapper": 
            case "objectMapper": {
                return target.getObjectMapper();
            }
            case "prettyprint": 
            case "prettyPrint": {
                return target.isPrettyPrint();
            }
        }
        return null;
    }
}

