/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.schibsted.spt.data.jslt.Callable;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.Module;
import com.schibsted.spt.data.jslt.impl.AbstractCallable;
import com.schibsted.spt.data.jslt.impl.ExpressionNode;
import com.schibsted.spt.data.jslt.impl.Macro;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;
import java.util.HashMap;
import java.util.Map;

public class ExperimentalModule
implements Module {
    public static final String URI = "http://jslt.schibsted.com/2018/experimental";
    private Map<String, Callable> callables = new HashMap<String, Callable>();

    public ExperimentalModule() {
        this.register(new GroupBy());
    }

    @Override
    public Callable getCallable(String name) {
        return this.callables.get(name);
    }

    private void register(Callable callable) {
        this.callables.put(callable.getName(), callable);
    }

    public static class GroupBy
    extends AbstractCallable
    implements Macro {
        public GroupBy() {
            super("group-by", 3, 3);
        }

        @Override
        public JsonNode call(Scope scope, JsonNode input, ExpressionNode[] parameters) {
            JsonNode array = parameters[0].apply(scope, input);
            if (array.isNull()) {
                return NullNode.instance;
            }
            if (array.isObject()) {
                array = NodeUtils.convertObjectToArray(array);
            } else if (!array.isArray()) {
                throw new JsltException("Can't group-by on " + array);
            }
            HashMap<JsonNode, ArrayNode> groups = new HashMap<JsonNode, ArrayNode>();
            for (int ix = 0; ix < array.size(); ++ix) {
                JsonNode groupInput = array.get(ix);
                JsonNode key = parameters[1].apply(scope, groupInput);
                JsonNode value = parameters[2].apply(scope, groupInput);
                ArrayNode values = (ArrayNode)groups.get(key);
                if (values == null) {
                    values = NodeUtils.mapper.createArrayNode();
                    groups.put(key, values);
                }
                values.add(value);
            }
            ArrayNode result = NodeUtils.mapper.createArrayNode();
            for (JsonNode key : groups.keySet()) {
                ObjectNode group = NodeUtils.mapper.createObjectNode();
                group.set("key", key);
                group.set("values", (JsonNode)groups.get(key));
                result.add(group);
            }
            return result;
        }
    }
}

