/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonapi;

import com.github.jasminb.jsonapi.JSONAPIDocument;
import com.github.jasminb.jsonapi.ResourceConverter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.spi.annotations.Dataformat;
import org.apache.camel.support.service.ServiceSupport;

@Dataformat(value="jsonApi")
public class JsonApiDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName,
CamelContextAware {
    private CamelContext camelContext;
    private String dataFormatTypes;
    private Class<?>[] dataFormatTypeClasses;
    private String mainFormatType;
    private Class<?> mainFormatTypeClass;

    public JsonApiDataFormat() {
    }

    public JsonApiDataFormat(Class<?>[] dataFormatTypesClasses) {
        this.dataFormatTypeClasses = dataFormatTypesClasses;
    }

    public JsonApiDataFormat(Class<?> mainFormatTypeClass, Class<?>[] dataFormatTypes) {
        this.mainFormatTypeClass = mainFormatTypeClass;
        this.dataFormatTypeClasses = dataFormatTypes;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getDataFormatName() {
        return "jsonApi";
    }

    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ResourceConverter converter = new ResourceConverter(this.dataFormatTypeClasses);
        byte[] objectAsBytes = converter.writeDocument(new JSONAPIDocument<Object>(graph));
        stream.write(objectAsBytes);
    }

    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        return this.unmarshal(exchange, (Object)stream);
    }

    @Override
    public Object unmarshal(Exchange exchange, Object body) throws Exception {
        JSONAPIDocument<?> doc;
        ResourceConverter converter = new ResourceConverter(this.dataFormatTypeClasses);
        if (body instanceof byte[]) {
            byte[] arr = (byte[])body;
            doc = converter.readDocument(arr, this.mainFormatTypeClass);
        } else {
            InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, body);
            doc = converter.readDocument(is, this.mainFormatTypeClass);
        }
        return doc.get();
    }

    public String getDataFormatTypes() {
        return this.dataFormatTypes;
    }

    public void setDataFormatTypes(String dataFormatTypes) {
        this.dataFormatTypes = dataFormatTypes;
    }

    public Class<?>[] getDataFormatTypeClasses() {
        return this.dataFormatTypeClasses;
    }

    public void setDataFormatTypeClasses(Class<?>[] dataFormatTypeClasses) {
        this.dataFormatTypeClasses = dataFormatTypeClasses;
    }

    public String getMainFormatType() {
        return this.mainFormatType;
    }

    public void setMainFormatType(String mainFormatType) {
        this.mainFormatType = mainFormatType;
    }

    public Class<?> getMainFormatTypeClass() {
        return this.mainFormatTypeClass;
    }

    public void setMainFormatTypeClass(Class<?> mainFormatTypeClass) {
        this.mainFormatTypeClass = mainFormatTypeClass;
    }

    @Override
    protected void doBuild() throws Exception {
        if (this.dataFormatTypeClasses == null && this.dataFormatTypes != null) {
            ArrayList classes = new ArrayList();
            for (String name : this.dataFormatTypes.split(",")) {
                Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
                classes.add(clazz);
            }
            this.dataFormatTypeClasses = classes.toArray(new Class[0]);
        }
        if (this.mainFormatTypeClass == null && this.mainFormatType != null) {
            this.mainFormatTypeClass = this.getCamelContext().getClassResolver().resolveMandatoryClass(this.mainFormatType);
        }
    }
}

